<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
    xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
    xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper" 
    xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
    exclude-result-prefixes="ametys resolver">

    <xsl:template match="question[@type = 'form.File']" mode="question-attribute-class">
        <xsl:attribute name="class">question question-file</xsl:attribute>
    </xsl:template>
    
    <xsl:template match="question[@type = 'form.File']" mode="field-attribute-class">
        <xsl:attribute name="class">field field-file</xsl:attribute>
    </xsl:template>
    
    <xsl:template match="question[@type = 'form.File']" mode="input-attribute-class">
        <xsl:attribute name="class">input input-file</xsl:attribute>
    </xsl:template>
    
    <xsl:template match="question[@type = 'form.File']" mode="read-only-value">
        <xsl:param name="value" />
        
        <a href="{resolver:resolve('attribute', $value/@uri, 'true')}"><xsl:value-of select="$value/@filename" /></a>
    </xsl:template>
    
    <xsl:template match="question[@type = 'form.File']" mode="render-mail">
        <!-- Files are sent as attachments -->
        <xsl:value-of select="value/@filename" />
    </xsl:template>
    
    <xsl:template match="question[@type = 'form.File']" mode="input">
        <xsl:if test="entry-value/value">
            <div class="input-field-value">
                <a href="{resolver:resolve('attribute', entry-value/value/@uri, 'true')}"><xsl:value-of select="entry-value/value/@filename" /></a>
                <a href="javascript:void(0)" onclick="AmetysFormsHelper.removeFile(this, '{@name}')"><i18n:text i18n:key="PLUGINS_FORMS_FILE_REMOVE_BUTTON"/></a>
                <input type="hidden" value="untouched" name="{@name}-info" id="{@name}-info" />
            </div>
        </xsl:if>
        <input class="input-field" type="file" id="{@name}_{$uniqueId}" name="{@name}" style="display:none">
            <xsl:if test="mandatory = 'true'">
                <xsl:attribute name="aria-required">true</xsl:attribute>
            </xsl:if>
            <xsl:attribute name="accept"><xsl:value-of select="additional-infos/allowed-extensions"/></xsl:attribute>
        </input>
    </xsl:template>
    
    <!-- Override to handle 'untouched' value (edit mode only) -->
    <xsl:template match="question[@type = 'form.File' and mandatory = 'true']" mode="check-mandatory">
        var field = $j('#<xsl:value-of select="@name"/>_<xsl:value-of select="$uniqueId"/>')
        
        var untouchedField = field.closest('.field').find('input[name="<xsl:value-of select="@name"/>-info"]');
        if (untouchedField &amp;&amp; untouchedField.val() == 'untouched')
        {
            return; // File value untouched
        }
        
        var value = field.val();
        var parentField = $j('#form-<xsl:value-of select="$uniqueId"/>-q-<xsl:value-of select="@name"/>');
        if (value == '' &amp;&amp; !field.is(":hidden") &amp;&amp; !field.prop('disabled')  &amp;&amp; !parentField.hasClass("preview-hide"))
        {
            AmetysFormsHelper.addFormError('<xsl:value-of select="$uniqueId"/>', '<xsl:value-of select="@name"/>_<xsl:value-of select="$uniqueId"/>', '<xsl:value-of select="ametys:escapeJS(title)"/>', "<i18n:text i18n:key="PLUGINS_FORMS_PAGE_FORM_ERROR_MANDATORY"/>");
        }
    </xsl:template>
    
    <xsl:template match="question[@type = 'form.File']" mode="check-values">
        var files = $j('#<xsl:value-of select="@name"/>_<xsl:value-of select="$uniqueId"/>')[0].files;
        if (files.length > 0)
        {
            var msg = "<i18n:translate>
                            <i18n:text i18n:key="PLUGINS_FORMS_PAGE_FORM_ERROR_FILE_SIZE"/>
                            <i18n:param name="max"><xsl:value-of select="additional-infos/max-size"/></i18n:param>
                       </i18n:translate>";
            var filesize = ((files[0].size/1024)/1024).toFixed(4);
            if (<xsl:value-of select="additional-infos/max-size"/> &lt; filesize)
            {
                AmetysFormsHelper.addFormError('<xsl:value-of select="$uniqueId"/>', '<xsl:value-of select="@name"/>_<xsl:value-of select="$uniqueId"/>', '<xsl:value-of select="ametys:escapeJS(title)"/>', msg);
            }
            
            <xsl:if test="additional-infos/allowed-extensions != ''">
	            var extensions = ('<xsl:value-of select="additional-infos/allowed-extensions"/>').split(',');
	            var trimExtensions = [];
	            for (var i in extensions)
	            {
	               if (extensions[i].trim() != "")
	               {
	                   trimExtensions.push(extensions[i].trim());
	               }
	            }

	            if (trimExtensions.length > 0)
	            {
	                var fileExtension = files[0].name.split('.').pop();
	                if (!trimExtensions.includes("." + fileExtension.toLowerCase()))
	                {
	                    msg = "<i18n:translate>
	                                <i18n:text i18n:key="PLUGINS_FORMS_PAGE_FORM_ERROR_FILE_EXTENSION"/>
	                                <i18n:param name="extensions"><xsl:value-of select="additional-infos/allowed-extensions"/></i18n:param>
	                           </i18n:translate>";
                        AmetysFormsHelper.addFormError('<xsl:value-of select="$uniqueId"/>', '<xsl:value-of select="@name"/>_<xsl:value-of select="$uniqueId"/>', '<xsl:value-of select="ametys:escapeJS(title)"/>', msg);
	                }
	            }
            </xsl:if>
        }
    </xsl:template>
</xsl:stylesheet>