/*
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.forms;

import org.apache.commons.lang3.StringUtils;

import org.ametys.runtime.i18n.I18nizableText;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;

/**
 * Form errors.
 */
public class FormErrors
{
    /** The errors as a Map of field ID -&gt; error messages. */
    protected Multimap<String, I18nizableText> _errors;
    
    /**
     * Default constructor.
     */
    public FormErrors()
    {
        this(ArrayListMultimap.create());
    }
    
    /**
     * Constructor with parameters.
     * @param errors the errors.
     */
    public FormErrors(Multimap<String, I18nizableText> errors)
    {
        this._errors = errors;
    }
    
    /**
     * Get the errors.
     * @return the errors
     */
    public Multimap<String, I18nizableText> getErrors()
    {
        return _errors;
    }
    
    /**
     * Set the errors.
     * @param errors the errors to set
     */
    public void setErrors(Multimap<String, I18nizableText> errors)
    {
        this._errors = errors;
    }
    
    /**
     * Add an error.
     * @param fieldId the field ID.
     * @param error the error message.
     */
    public void addError(String fieldId, I18nizableText error)
    {
        if (StringUtils.isNotEmpty(fieldId) && error != null)
        {
            if (_errors.containsKey(fieldId))
            {
                _errors.get(fieldId).add(error);
            }
            else
            {
                _errors.put(fieldId, error);
            }
        }
    }
    
    /**
     * Tests if the form has errors.
     * @return true if there are errors, false otherwise.
     */
    public boolean hasErrors()
    {
        if (!_errors.isEmpty())
        {
            return true;
        }
        return false;
    }
}
