/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.question.validators;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.FormatStyle;
import java.util.HashMap;
import org.ametys.plugins.forms.question.validators.AbstractIntervalFormValidator;
import org.ametys.runtime.i18n.I18nizableDateTime;
import org.ametys.runtime.i18n.I18nizableText;

public class DateTimeIntervalFormValidator
extends AbstractIntervalFormValidator<ZonedDateTime> {
    public DateTimeIntervalFormValidator(String regexp, boolean mandatory, ZonedDateTime min, ZonedDateTime max) {
        super(regexp, mandatory, min, max);
    }

    @Override
    protected boolean isLessThan(ZonedDateTime dateToValidate, ZonedDateTime dateMin) {
        return dateToValidate.isBefore(dateMin);
    }

    @Override
    protected boolean isMoreThan(ZonedDateTime dateToValidate, ZonedDateTime dateMax) {
        return dateToValidate.isAfter(dateMax);
    }

    @Override
    protected I18nizableText getIntervalError(ZonedDateTime min, ZonedDateTime max) {
        HashMap<String, I18nizableDateTime> i18nParams = new HashMap<String, I18nizableDateTime>();
        i18nParams.put("startDate", new I18nizableDateTime(min, ZoneId.systemDefault(), FormatStyle.SHORT));
        i18nParams.put("endDate", new I18nizableDateTime(max, ZoneId.systemDefault(), FormatStyle.SHORT));
        return new I18nizableText("plugin.forms", "PLUGINS_FORMS_ENTRY_VALIDATOR_DATE_INTERVAL_ERROR", i18nParams);
    }
}

