/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.repository;

import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Optional;
import javax.jcr.Node;
import org.ametys.cms.data.ametysobject.ModifiableModelAwareDataAwareAmetysObject;
import org.ametys.cms.data.holder.ModifiableIndexableDataHolder;
import org.ametys.cms.data.holder.impl.DefaultModifiableModelAwareDataHolder;
import org.ametys.cms.repository.WorkflowAwareContentHelper;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.population.UserPopulationDAO;
import org.ametys.plugins.forms.question.FormQuestionType;
import org.ametys.plugins.forms.question.types.ConfidentialAwareQuestionType;
import org.ametys.plugins.forms.repository.Form;
import org.ametys.plugins.forms.repository.FormEntryFactory;
import org.ametys.plugins.forms.repository.FormQuestion;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.data.repositorydata.ModifiableRepositoryData;
import org.ametys.plugins.repository.data.repositorydata.impl.JCRRepositoryData;
import org.ametys.plugins.repository.jcr.JCRAmetysObject;
import org.ametys.plugins.repository.jcr.SimpleAmetysObject;
import org.ametys.plugins.repository.jcr.SimpleAmetysObjectFactory;
import org.ametys.plugins.workflow.repository.WorkflowAwareAmetysObject;
import org.ametys.runtime.model.ModelItemContainer;

public class FormEntry
extends SimpleAmetysObject<FormEntryFactory>
implements ModifiableModelAwareDataAwareAmetysObject,
WorkflowAwareAmetysObject {
    public static final String SYSTEM_ATTRIBUTE_PREFIX = "ametys-";
    public static final String ATTRIBUTE_ID = "ametys-id";
    public static final String ATTRIBUTE_SUBMIT_DATE = "ametys-submit-date";
    public static final String ATTRIBUTE_IP = "ametys-ipAddress";
    public static final String ATTRIBUTE_USER = "ametys-user";
    public static final String ATTRIBUTE_ACTIVE = "ametys-active";
    public static final String ATTRIBUTE_ANONYMIZATION_DATE = "anonymizationDate";

    public FormEntry(Node node, String parentPath, FormEntryFactory factory) {
        super(node, parentPath, (SimpleAmetysObjectFactory)factory);
    }

    public Form getForm() {
        return (Form)this.getParent().getParent();
    }

    public Long getEntryId() {
        return (Long)this.getValue(ATTRIBUTE_ID);
    }

    public void setEntryId(Long id) {
        this.setValue(ATTRIBUTE_ID, id);
    }

    public String getIP() {
        return (String)this.getValue(ATTRIBUTE_IP);
    }

    public void setIP(String ip) {
        this.setValue(ATTRIBUTE_IP, ip);
    }

    public ZonedDateTime getSubmitDate() {
        return (ZonedDateTime)this.getValue(ATTRIBUTE_SUBMIT_DATE);
    }

    public void setSubmitDate(ZonedDateTime submitDate) {
        this.setValue(ATTRIBUTE_SUBMIT_DATE, submitDate);
    }

    public void setUser(UserIdentity user) {
        this.setValue(ATTRIBUTE_USER, user);
    }

    public Boolean isActive() {
        return (Boolean)this.getValue(ATTRIBUTE_ACTIVE, false, true);
    }

    public void setActive(Boolean isActive) {
        this.setValue(ATTRIBUTE_ACTIVE, isActive);
    }

    public UserIdentity getUser() {
        return (UserIdentity)this.getValue(ATTRIBUTE_USER);
    }

    public void anonymize() {
        Form form = this.getForm();
        for (FormQuestion question : form.getQuestions()) {
            FormQuestionType type;
            ConfidentialAwareQuestionType confidentialType;
            FormQuestionType questionType = question.getType();
            if (!(questionType instanceof ConfidentialAwareQuestionType) || !(confidentialType = (ConfidentialAwareQuestionType)((Object)questionType)).isConfidential(question) || (type = question.getType()).onlyForDisplay(question)) continue;
            Map<String, Object> anonymizedData = type.getAnonymizedData(question);
            for (Map.Entry<String, Object> entry : anonymizedData.entrySet()) {
                String dataName = entry.getKey();
                if (!this.hasValue(dataName)) continue;
                this.setValue(dataName, entry.getValue());
            }
        }
        this.setIP("0.0.0.0");
        this.setUser(UserPopulationDAO.UNKNOWN_USER_IDENTITY);
        this.setValue(ATTRIBUTE_ANONYMIZATION_DATE, ZonedDateTime.now());
        if (this.needsSave()) {
            this.saveChanges();
        }
    }

    public long getWorkflowId() throws AmetysRepositoryException {
        return WorkflowAwareContentHelper.getWorkflowId((JCRAmetysObject)this);
    }

    public void setWorkflowId(long workflowId) throws AmetysRepositoryException {
        WorkflowAwareContentHelper.setWorkflowId((JCRAmetysObject)this, (long)workflowId);
    }

    public long getCurrentStepId() throws AmetysRepositoryException {
        return WorkflowAwareContentHelper.getCurrentStepId((JCRAmetysObject)this);
    }

    public void setCurrentStepId(long stepId) throws AmetysRepositoryException {
        WorkflowAwareContentHelper.setCurrentStepId((JCRAmetysObject)this, (long)stepId);
    }

    public ModifiableIndexableDataHolder getDataHolder() {
        JCRRepositoryData repositoryData = new JCRRepositoryData(this.getNode());
        return new DefaultModifiableModelAwareDataHolder((ModifiableRepositoryData)repositoryData, (ModelItemContainer)((FormEntryFactory)this._getFactory()).getFormEntryModel(this.getForm()), Optional.empty(), Optional.empty(), Optional.of(this));
    }
}

