/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.workflow;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.WorkflowException;
import java.util.List;
import java.util.Map;
import org.ametys.cms.workflow.AmetysObjectCheckRightsCondition;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.plugins.forms.repository.FormEntry;
import org.ametys.plugins.workflow.EnhancedCondition;
import org.ametys.plugins.workflow.component.WorkflowArgument;
import org.ametys.plugins.workflow.support.WorkflowElementDefinitionHelper;
import org.ametys.plugins.workflow.support.WorkflowHelper;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;

public class IsUserCondition
extends AbstractLogEnabled
implements EnhancedCondition,
Serviceable {
    public static final String QUESTION_NAME = "question-name";
    protected UserManager _userManager;
    protected CurrentUserProvider _currentUserProvider;

    public void service(ServiceManager manager) throws ServiceException {
        this._userManager = (UserManager)manager.lookup(UserManager.ROLE);
        this._currentUserProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
    }

    public boolean passesCondition(Map transientVars, Map args, PropertySet ps) throws WorkflowException {
        FormEntry formEntry = (FormEntry)((Object)transientVars.get(AmetysObjectCheckRightsCondition.AMETYS_OBJECT_KEY));
        String questionName = (String)args.get(QUESTION_NAME);
        if (StringUtils.isBlank((CharSequence)questionName) || !formEntry.hasDefinition(questionName) || !formEntry.getType(questionName).getId().equals("user")) {
            this.getLogger().warn("Given argument '" + questionName + "' for condition is not an user form question");
            return false;
        }
        UserIdentity userId = (UserIdentity)formEntry.getValue(questionName);
        return userId != null && userId.equals((Object)this._currentUserProvider.getUser());
    }

    public List<WorkflowArgument> getArguments() {
        WorkflowArgument questionName = WorkflowElementDefinitionHelper.getElementDefinition((String)QUESTION_NAME, (I18nizableText)new I18nizableText("plugin.forms", "PLUGINS_FORMS_IS_USER_ARGUMENT_QUESTION_NAME_LABEL"), (I18nizableText)new I18nizableText("plugin.forms", "PLUGINS_FORMS_IS_USER_ARGUMENT_QUESTION_NAME_DESCRIPTION"), (boolean)true, (boolean)false);
        return List.of(questionName);
    }

    public I18nizableText getLabel() {
        return new I18nizableText("plugin.forms", "PLUGINS_FORMS_IS_USER_CONDITION_LABEL");
    }

    public I18nizableText getFullLabel(Map<String, String> argumentsValues) {
        String questionName = argumentsValues.get(QUESTION_NAME);
        return new I18nizableText("plugin.forms", "PLUGINS_FORMS_IS_USER_CONDITION_DESCRIPTION", List.of(questionName));
    }

    public List<WorkflowHelper.WorkflowVisibility> getVisibilities() {
        List visibilities = super.getVisibilities();
        visibilities.add(WorkflowHelper.WorkflowVisibility.USER);
        return visibilities;
    }
}

