/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.dao;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.ametys.core.observation.ObservationManager;
import org.ametys.core.right.RightManager;
import org.ametys.core.ui.Callable;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.LambdaUtils;
import org.ametys.plugins.forms.FormXpathUtils;
import org.ametys.plugins.forms.dao.FormDAO;
import org.ametys.plugins.forms.repository.Form;
import org.ametys.plugins.forms.repository.FormDirectory;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.ModifiableTraversableAmetysObject;
import org.ametys.plugins.repository.MovableAmetysObject;
import org.ametys.plugins.repository.TraversableAmetysObject;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.repository.jcr.NameHelper;
import org.ametys.runtime.authentication.AccessDeniedException;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.web.repository.site.SiteManager;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class FormDirectoryDAO
extends AbstractLogEnabled
implements Serviceable,
Component {
    public static final String ROLE = FormDirectoryDAO.class.getName();
    public static final String ROOT_FORM_DIRECTORY_ID = "root";
    public static final String HANDLE_FORM_DIRECTORIES_RIGHT_ID = "FormsDirectory_Rights_Directories";
    private static final String __ROOT_NODE_NAME = "ametys:forms";
    private static final String __PLUGIN_NODE_NAME = "forms";
    private static final String __FORMDIRECTORY_NAME_PREFIX = "formdirectory-";
    protected ObservationManager _observationManager;
    protected SiteManager _siteManager;
    protected CurrentUserProvider _userProvider;
    protected AmetysObjectResolver _resolver;
    protected RightManager _rightManager;
    protected FormDAO _formDAO;

    public void service(ServiceManager manager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._userProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
        this._siteManager = (SiteManager)manager.lookup(SiteManager.ROLE);
        this._observationManager = (ObservationManager)manager.lookup(ObservationManager.ROLE);
        this._rightManager = (RightManager)manager.lookup(RightManager.ROLE);
        this._formDAO = (FormDAO)((Object)manager.lookup(FormDAO.ROLE));
    }

    public boolean hasWriteRightOnFormDirectory(UserIdentity userIdentity, FormDirectory formDirectory) {
        return this._rightManager.hasRight(userIdentity, HANDLE_FORM_DIRECTORIES_RIGHT_ID, (Object)formDirectory) == RightManager.RightResult.RIGHT_ALLOW;
    }

    public void checkHandleFormDirectoriesRight(AmetysObject formElement) {
        UserIdentity user = this._userProvider.getUser();
        if (!this.hasWriteRightOnFormDirectory(user, null)) {
            throw new AccessDeniedException("User '" + String.valueOf(user) + "' tried to handle form directories without convenient right [FormsDirectory_Rights_Directories]");
        }
    }

    public FormDirectory getFormDirectoriesRootNode(String siteName) throws AmetysRepositoryException {
        try {
            return this._getOrCreateRootNode(siteName);
        }
        catch (AmetysRepositoryException e) {
            throw new AmetysRepositoryException("Unable to get the forms root node", (Throwable)e);
        }
    }

    private FormDirectory _getOrCreateRootNode(String siteName) throws AmetysRepositoryException {
        ModifiableTraversableAmetysObject pluginsNode = this._siteManager.getSite(siteName).getRootPlugins();
        ModifiableTraversableAmetysObject pluginNode = (ModifiableTraversableAmetysObject)this._getOrCreateNode(pluginsNode, __PLUGIN_NODE_NAME, "ametys:unstructured");
        return (FormDirectory)this._getOrCreateNode(pluginNode, __ROOT_NODE_NAME, __ROOT_NODE_NAME);
    }

    private AmetysObject _getOrCreateNode(ModifiableTraversableAmetysObject parentNode, String nodeName, String nodeType) throws AmetysRepositoryException {
        AmetysObject definitionsNode;
        if (parentNode.hasChild(nodeName)) {
            definitionsNode = parentNode.getChild(nodeName);
        } else {
            definitionsNode = parentNode.createChild(nodeName, nodeType);
            parentNode.saveChanges();
        }
        return definitionsNode;
    }

    @Callable(rights={"FormsDirectory_Rights_Tool", "CMS_Rights_Delegate_Rights", "Runtime_Rights_Rights_Handle"})
    public Map<String, Object> getRootProperties(String siteName) {
        return this.getFormDirectoryProperties(this.getFormDirectoriesRootNode(siteName), false);
    }

    @Callable(rights={"*"})
    public Map<String, Object> getFormDirectoryProperties(String siteName, String id) {
        return this.getFormDirectoryProperties(this.getFormDirectory(siteName, id), true);
    }

    public Map<String, Object> getFormDirectoryProperties(FormDirectory formDirectory, boolean withRights) {
        HashMap<String, Object> infos = new HashMap<String, Object>();
        infos.put("isForm", false);
        infos.put("id", formDirectory.getId());
        infos.put("title", formDirectory.getTitle());
        infos.put("fullPath", this.getFormDirectoryPath(formDirectory, " > "));
        FormDirectory formDirectoriesRoot = this.getFormDirectoriesRootNode(formDirectory.getSiteName());
        String parentId = formDirectory.getParent().getId().equals(formDirectoriesRoot.getId()) ? ROOT_FORM_DIRECTORY_ID : formDirectory.getParent().getId();
        infos.put("parentId", parentId);
        infos.put("hasChildren", formDirectory.getChildren().getSize() != 0L);
        UserIdentity currentUser = this._userProvider.getUser();
        boolean canWriteParent = formDirectory.getParent() instanceof FormDirectory && this.hasWriteRightOnFormDirectory(currentUser, (FormDirectory)formDirectory.getParent());
        infos.put("canEditRight", this.hasRightAffectationRightOnFormDirectory(currentUser, formDirectory));
        if (withRights) {
            infos.put("canWriteParent", canWriteParent);
            infos.put("rights", this._getUserRights(formDirectory));
        } else {
            boolean canRead = this.hasReadRightOnFormDirectory(currentUser, formDirectory);
            boolean canWrite = this.hasWriteRightOnFormDirectory(currentUser, formDirectory);
            infos.put("canRename", canWrite && canWriteParent);
            infos.put("canWrite", canWrite);
            infos.put("canEdit", canWrite && this._hasWriteRightOnEachDescendant(currentUser, formDirectory) && canWriteParent);
            infos.put("displayForRead", canRead || canWrite || this.hasAnyReadableDescendant(currentUser, formDirectory) != false || this.hasAnyWritableDescendant(currentUser, formDirectory) != false);
            infos.put("displayForWrite", canWrite || this._hasAnyWriteDescendantFolder(currentUser, formDirectory) != false);
            infos.put("displayForRights", canWrite || this.hasAnyAssignableDescendant(currentUser, formDirectory) != false);
        }
        return infos;
    }

    protected Set<String> _getUserRights(FormDirectory formDirectory) {
        UserIdentity user = this._userProvider.getUser();
        return this._rightManager.getUserRights(user, (Object)formDirectory);
    }

    public FormDirectory getFormDirectory(String siteName, String id) {
        return ROOT_FORM_DIRECTORY_ID.equals(id) ? this.getFormDirectoriesRootNode(siteName) : (FormDirectory)this._resolver.resolveById(id);
    }

    public String getFormDirectoryPath(FormDirectory formDirectory, String separator) {
        FormDirectory parentDirectory;
        ArrayList<String> fullPath = new ArrayList<String>();
        fullPath.add(formDirectory.getTitle());
        AmetysObject parent = formDirectory.getParent();
        while (parent instanceof FormDirectory && !this.isRoot(parentDirectory = (FormDirectory)parent)) {
            fullPath.add(0, parentDirectory.getTitle());
            parent = parent.getParent();
        }
        return String.join((CharSequence)separator, fullPath);
    }

    public boolean isRoot(FormDirectory formDirectory) {
        return __ROOT_NODE_NAME.equals(formDirectory.getName());
    }

    @Callable(rights={""})
    public Map<String, Object> createFormDirectory(String siteName, String parentId, String name) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        FormDirectory parent = this.getFormDirectory(siteName, parentId);
        this.checkHandleFormDirectoriesRight((AmetysObject)parent);
        String uniqueName = NameHelper.getUniqueAmetysObjectName((TraversableAmetysObject)parent, (String)(__FORMDIRECTORY_NAME_PREFIX + name));
        FormDirectory formDirectory = (FormDirectory)parent.createChild(uniqueName, __ROOT_NODE_NAME);
        formDirectory.setTitle(name);
        parent.saveChanges();
        results.put("id", formDirectory.getId());
        results.put("title", formDirectory.getTitle());
        results.put("parentId", parent.getId());
        return results;
    }

    @Callable(rights={""})
    public Map<String, Object> renameFormDirectory(String id, String newName) {
        FormDirectory directory = (FormDirectory)this._resolver.resolveById(id);
        this.checkHandleFormDirectoriesRight((AmetysObject)directory);
        HashMap<String, Object> results = new HashMap<String, Object>();
        AmetysObject parent = directory.getParent();
        if (parent instanceof FormDirectory) {
            FormDirectory parentDirectory = (FormDirectory)parent;
            UserIdentity currentUser = this._userProvider.getUser();
            boolean canWrite = this.hasWriteRightOnFormDirectory(currentUser, directory);
            boolean canWriteParent = this.hasWriteRightOnFormDirectory(currentUser, parentDirectory);
            if (canWrite && canWriteParent) {
                String uniqueName = NameHelper.getUniqueAmetysObjectName((TraversableAmetysObject)parentDirectory, (String)(__FORMDIRECTORY_NAME_PREFIX + newName));
                Node node = directory.getNode();
                try {
                    node.getSession().move(node.getPath(), node.getParent().getPath() + "/" + uniqueName);
                    directory.setTitle(newName);
                    node.getSession().save();
                    results.put("id", id);
                    results.put("title", directory.getTitle());
                }
                catch (RepositoryException e) {
                    this.getLogger().warn("Form directory renaming failed.", (Throwable)e);
                    results.put("message", "cannot-rename");
                }
            } else {
                results.put("message", "not-allowed");
            }
        } else {
            results.put("message", "not-allowed");
        }
        return results;
    }

    @Callable(rights={""})
    public Map<String, Object> deleteFormDirectory(List<String> ids) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        ArrayList<ImmutableMap> allDeleted = new ArrayList<ImmutableMap>();
        ArrayList<ImmutableMap> allUnknown = new ArrayList<ImmutableMap>();
        if (!this.canDeleteAllFormDirectories(ids)) {
            results.put("message", "not-allowed");
            return results;
        }
        for (String id : ids) {
            try {
                FormDirectory directory = (FormDirectory)this._resolver.resolveById(id);
                String name = directory.getName();
                String title = directory.getTitle();
                directory.remove();
                directory.saveChanges();
                ImmutableMap deleted = ImmutableMap.of((Object)"id", (Object)id, (Object)"name", (Object)name, (Object)"title", (Object)title);
                allDeleted.add(deleted);
            }
            catch (UnknownAmetysObjectException e) {
                ImmutableMap unknown = ImmutableMap.of((Object)"id", (Object)id);
                allUnknown.add(unknown);
                this.getLogger().error("Unable to delete form directory. The directory of id '" + id + " doesn't exist", (Throwable)e);
            }
        }
        results.put("deleted", allDeleted);
        results.put("unknown", allUnknown);
        return results;
    }

    @Callable(rights={""})
    public Map<String, Object> moveFormDirectory(String siteName, String id, String newParentId) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        FormDirectory formDirectory = (FormDirectory)this._resolver.resolveById(id);
        FormDirectory parentFormDirectory = this.getFormDirectory(siteName, newParentId);
        UserIdentity currentUser = this._userProvider.getUser();
        if (this._hasWriteRightOnEachDescendant(currentUser, formDirectory) && this.hasWriteRightOnFormDirectory(currentUser, parentFormDirectory)) {
            this.move(formDirectory, siteName, newParentId, results);
        } else {
            results.put("message", "not-allowed");
        }
        results.put("id", formDirectory.getId());
        results.put("title", formDirectory.getTitle());
        return results;
    }

    public void move(MovableAmetysObject obj, String siteName, String newParentId, Map<String, Object> results) {
        FormDirectory newParent = this.getFormDirectory(siteName, newParentId);
        if (obj.canMoveTo((AmetysObject)newParent)) {
            try {
                obj.moveTo((AmetysObject)newParent, false);
            }
            catch (AmetysRepositoryException e) {
                this.getLogger().warn("Form moving failed.", (Throwable)e);
                results.put("message", "cannot-move");
            }
        } else {
            results.put("message", "cannot-move");
        }
    }

    @Callable(rights={"*"})
    public boolean mustWarnBeforeDeletion(List<String> ids) {
        return ids.stream().anyMatch(LambdaUtils.wrapPredicate(this::_mustWarnBeforeDeletion));
    }

    private boolean _mustWarnBeforeDeletion(String id) {
        FormDirectory directory = (FormDirectory)this._resolver.resolveById(id);
        AmetysObjectIterable<Form> allForms = this.getChildFormsForAdministrator(directory, false);
        return this._containsNotOwnForms(allForms);
    }

    private boolean _containsNotOwnForms(AmetysObjectIterable<Form> allForms) {
        UserIdentity currentUser = this._userProvider.getUser();
        return allForms.stream().map(Form::getAuthor).anyMatch((Predicate<UserIdentity>)Predicates.not(arg_0 -> ((UserIdentity)currentUser).equals(arg_0)));
    }

    protected boolean canDeleteAllFormDirectories(List<String> ids) {
        return this.canDeleteFormDirectories(ids).values().stream().allMatch(Boolean.TRUE::equals);
    }

    @Callable(rights={"*"})
    public Map<String, Boolean> canDeleteFormDirectories(List<String> ids) {
        return ids.stream().collect(Collectors.toMap(Function.identity(), LambdaUtils.wrap(this::_canDeleteFormDirectory)));
    }

    private boolean _canDeleteFormDirectory(String id) {
        FormDirectory directory;
        if (ROOT_FORM_DIRECTORY_ID.equals(id)) {
            return false;
        }
        UserIdentity user = this._userProvider.getUser();
        return this._hasWriteRightOnEachDescendant(user, directory = (FormDirectory)this._resolver.resolveById(id)) && !this._hasPublishedForms(directory) && directory.getParent() instanceof FormDirectory && this.hasWriteRightOnFormDirectory(user, (FormDirectory)directory.getParent());
    }

    private boolean _hasPublishedForms(FormDirectory formDirectory) {
        boolean hasPublishedForms = false;
        for (AmetysObject child : formDirectory.getChildren()) {
            if (child instanceof FormDirectory) {
                hasPublishedForms = hasPublishedForms || this._hasPublishedForms((FormDirectory)child);
                continue;
            }
            if (!(child instanceof Form)) continue;
            hasPublishedForms = hasPublishedForms || !this._formDAO.getFormPage(child.getId(), formDirectory.getSiteName()).isEmpty();
        }
        return hasPublishedForms;
    }

    private boolean _hasWriteRightOnEachDescendant(UserIdentity userIdentity, FormDirectory formDirectory) {
        boolean hasRight = this.hasWriteRightOnFormDirectory(userIdentity, formDirectory);
        if (!hasRight) {
            return false;
        }
        try (AmetysObjectIterable children = formDirectory.getChildren();){
            for (AmetysObject child : children) {
                if (child instanceof FormDirectory) {
                    hasRight = hasRight && this._hasWriteRightOnEachDescendant(userIdentity, (FormDirectory)child);
                } else if (child instanceof Form) {
                    boolean bl = hasRight = hasRight && this.hasWriteRightOnFormAndParent(userIdentity, (Form)child, formDirectory);
                }
                if (hasRight) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = hasRight;
            return bl;
        }
    }

    public boolean hasWriteRightOnFormAndParent(UserIdentity userIdentity, Form form, FormDirectory formDirectory) {
        return form != null && userIdentity.equals((Object)form.getAuthor()) || this._formDAO.hasWriteRightOnForm(userIdentity, (AmetysObject)form) && this.hasWriteRightOnFormDirectory(userIdentity, formDirectory);
    }

    public Stream<Form> getChildFormsInWriteAccess(FormDirectory parent, boolean onlyDirect, UserIdentity user) {
        return this._resolver.query(FormXpathUtils.getXPathForForms(parent, onlyDirect)).stream().filter(Form.class::isInstance).map(obj -> (Form)((Object)obj)).filter(form -> this._formDAO.hasWriteRightOnForm(user, (AmetysObject)form));
    }

    public Stream<Form> getChildFormsInRightAccess(FormDirectory parent, boolean onlyDirect, UserIdentity user) {
        return this._resolver.query(FormXpathUtils.getXPathForForms(parent, onlyDirect)).stream().filter(Form.class::isInstance).map(obj -> (Form)((Object)obj)).filter(form -> this._formDAO.hasRightAffectationRightOnForm(user, (Form)((Object)form)));
    }

    public Stream<Form> getChildFormsInReadAccess(FormDirectory parent, boolean onlyDirect, UserIdentity user) {
        return this._resolver.query(FormXpathUtils.getXPathForForms(parent, onlyDirect)).stream().filter(Form.class::isInstance).map(obj -> (Form)((Object)obj)).filter(form -> this._formDAO.hasReadRightOnForm(user, (Form)((Object)form)));
    }

    public AmetysObjectIterable<Form> getChildFormsForAdministrator(FormDirectory parent, boolean onlyDirect) {
        return this._resolver.query(FormXpathUtils.getXPathForForms(parent, onlyDirect));
    }

    public AmetysObjectIterable<FormDirectory> getChildFormDirectories(FormDirectory parent) {
        return this._resolver.query(FormXpathUtils.getXPathForFormDirectories(parent));
    }

    protected UserIdentity _getCurrentUser() {
        return this._userProvider.getUser();
    }

    public boolean hasRightAffectationRightOnFormDirectory(UserIdentity userIdentity, FormDirectory formDirectory) {
        return this.hasWriteRightOnFormDirectory(userIdentity, formDirectory) || this._rightManager.hasRight(userIdentity, "Runtime_Rights_Rights_Handle", (Object)"/cms") == RightManager.RightResult.RIGHT_ALLOW;
    }

    public boolean hasReadRightOnFormDirectory(UserIdentity userIdentity, FormDirectory directory) {
        return this._rightManager.hasReadAccess(userIdentity, (Object)directory);
    }

    public Boolean hasAnyReadableDescendant(UserIdentity userIdentity, FormDirectory formDirectory) {
        boolean hasDescendant = this.hasReadRightOnFormDirectory(userIdentity, formDirectory);
        if (hasDescendant) {
            return true;
        }
        try (AmetysObjectIterable children = formDirectory.getChildren();){
            for (AmetysObject child : children) {
                if (child instanceof FormDirectory) {
                    hasDescendant = hasDescendant || this.hasAnyReadableDescendant(userIdentity, (FormDirectory)child) != false;
                } else if (child instanceof Form) {
                    boolean bl = hasDescendant = hasDescendant || this._formDAO.hasReadRightOnForm(userIdentity, (Form)child);
                }
                if (!hasDescendant) continue;
                Boolean bl = true;
                return bl;
            }
            Object object = hasDescendant;
            return object;
        }
    }

    public Boolean hasAnyWritableDescendant(UserIdentity userIdentity, FormDirectory formDirectory) {
        boolean hasDescendant = this.hasWriteRightOnFormDirectory(userIdentity, formDirectory);
        if (hasDescendant) {
            return true;
        }
        try (AmetysObjectIterable children = formDirectory.getChildren();){
            for (AmetysObject child : children) {
                if (child instanceof FormDirectory) {
                    hasDescendant = hasDescendant || this.hasAnyWritableDescendant(userIdentity, (FormDirectory)child) != false;
                } else if (child instanceof Form) {
                    boolean bl = hasDescendant = hasDescendant || this.hasWriteRightOnFormAndParent(userIdentity, (Form)child, formDirectory);
                }
                if (!hasDescendant) continue;
                Boolean bl = true;
                return bl;
            }
        }
        return hasDescendant;
    }

    private Boolean _hasAnyWriteDescendantFolder(UserIdentity userIdentity, FormDirectory formDirectory) {
        boolean hasDescendant = this.hasWriteRightOnFormDirectory(userIdentity, formDirectory);
        if (hasDescendant) {
            return true;
        }
        try (AmetysObjectIterable children = formDirectory.getChildren();){
            for (AmetysObject child : children) {
                if (child instanceof FormDirectory) {
                    boolean bl = hasDescendant = hasDescendant || this._hasAnyWriteDescendantFolder(userIdentity, (FormDirectory)child) != false;
                }
                if (!hasDescendant) continue;
                Boolean bl = true;
                return bl;
            }
            Object object = hasDescendant;
            return object;
        }
    }

    public Boolean hasAnyAssignableDescendant(UserIdentity userIdentity, FormDirectory formDirectory) {
        boolean hasDescendant = this.hasRightAffectationRightOnFormDirectory(userIdentity, formDirectory);
        if (hasDescendant) {
            return true;
        }
        try (AmetysObjectIterable children = formDirectory.getChildren();){
            for (AmetysObject child : children) {
                if (child instanceof FormDirectory) {
                    hasDescendant = hasDescendant || this.hasAnyAssignableDescendant(userIdentity, (FormDirectory)child) != false;
                } else if (child instanceof Form) {
                    boolean bl = hasDescendant = hasDescendant || this._formDAO.hasRightAffectationRightOnForm(userIdentity, (Form)child);
                }
                if (!hasDescendant) continue;
                Boolean bl = true;
                return bl;
            }
            Object object = hasDescendant;
            return object;
        }
    }
}

