/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.properties.section;

import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.ametys.cms.properties.section.AbstractDefaultPropertySection;
import org.ametys.core.util.DateUtils;
import org.ametys.plugins.core.user.UserHelper;
import org.ametys.plugins.forms.repository.FormEntry;
import org.ametys.plugins.repository.AmetysObject;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class FormEntrySubmitSection
extends AbstractDefaultPropertySection
implements Serviceable {
    private UserHelper _userHelper;

    public void service(ServiceManager smanager) throws ServiceException {
        this._userHelper = (UserHelper)smanager.lookup(UserHelper.ROLE);
    }

    public boolean supports(AmetysObject ametysObject) {
        return ametysObject instanceof FormEntry;
    }

    protected Map<String, Object> buildData(AmetysObject ametysObject) {
        LinkedHashMap<String, Object> resultMap = new LinkedHashMap<String, Object>();
        FormEntry formEntry = (FormEntry)ametysObject;
        resultMap.put("id", formEntry.getEntryId());
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("date", DateUtils.zonedDateTimeToString((ZonedDateTime)formEntry.getSubmitDate()));
        data.put("user", this._userHelper.user2json(formEntry.getUser(), true));
        resultMap.put("submit", data);
        return resultMap;
    }
}

