<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:exsl="http://exslt.org/common"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                extension-element-prefixes="exsl ametys resolver">
    
    <xsl:import href="service://pages/services/common/admin-dashboard.xsl"/>
    <xsl:import href="workspace:web://stylesheets/variables.xsl"/>     
    <xsl:import href="view://stylesheets/utils.xsl"/>    
    
    <xsl:param name="uniqueId" />
    
    <xsl:template match="dashboard">
        <html>
            <body>
                <div data-dashboard="results">
                    <!-- List of forms -->
                    <xsl:apply-templates select="forms" />
                    
                    <!-- Dashboard of a form -->
	                <xsl:apply-templates select="answers" />
                </div>
            </body>
        </html>
    </xsl:template>
    
    <xsl:template match="forms">
        <a name="forms-{$uniqueId}"/>
        <xsl:choose>
            <xsl:when test="count(form) > 0">
                <div class="forms">
                    <ul class="forms-list">
                        <xsl:apply-templates select="form"/>
                    </ul>
                </div>
            </xsl:when>
            <xsl:otherwise>
                <div class="no-form">
                    <p><i18n:text i18n:key="PLUGINS_FORMS_SERVICE_ADMIN_DASHBOARD_FORMS_NO_FORM" i18n:catalogue="plugin.forms"/></p>
                </div>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template match="form">
        <li class="forms-list__item">
            <a  href="javascript:void(0);" onclick="DashboardHelper.showAdminDashboard('{$uniqueId}', '{@id}', 1)">
                <xsl:apply-templates select="." mode="title"/>
            </a>
        </li>
    </xsl:template>
    
    <xsl:template match="form" mode="title">
        <span class="forms-list__item-title">
            <xsl:value-of select="title" />
        </span>
    </xsl:template>
    
    <xsl:template match="answers">
        <xsl:choose>
            <xsl:when test="count(answer) > 0 or filters/submitters/@value or filters/workflow-states/@value">
                <xsl:call-template name="dashboard" />
            </xsl:when>
            <xsl:otherwise>
               <div class="no-answer">
                   <p><i18n:text i18n:key="PLUGINS_FORMS_SERVICE_ADMIN_DASHBOARD_FORM_NO_DATA" i18n:catalogue="plugin.forms"/></p>
               </div>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
</xsl:stylesheet>
