<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:exsl="http://exslt.org/common"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                extension-element-prefixes="exsl ametys resolver">
    
    <xsl:import href="service:web://pages/services/common.xsl"/>
    <xsl:import href="service://pages/services/common/admin-dashboard.xsl"/>
    
    <xsl:param name="service-title" select="string(ametys:serviceParameter('header')/text())"/>
    
    <!-- Used in common.xsl -->
    <xsl:variable name="common-service-css-class-name">form-dashboard form-admin-dashboard</xsl:variable>
    <xsl:variable name="common-service-name">form-dashboard</xsl:variable>    
    
    <xsl:template name="common-service-head-js">
        <xsl:call-template name="admin-dashboard-js"/>
    </xsl:template>
    
    <xsl:template name="common-service-head-css">
        <xsl:call-template name="admin-dashboard-css"/>
    </xsl:template>
    
    <xsl:template name="common-service-head-title">
        <xsl:call-template name="common-service-head-title-content">
            <xsl:with-param name="title" select="$service-title"/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty-content-title">
        <xsl:call-template name="common-service-body-nonempty-content-title-content">
            <xsl:with-param name="title" select="$service-title"/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty-content-content">
        <div data-dashboard="{$uniqueId}">
            <div data-ametys-dashboard-role="results">
                <!-- Here will be inserted forms' list or form's dashbord in JS -->
            </div>
            <xsl:call-template name="loading-indicator"/>
        </div>
    </xsl:template>
    
    <xsl:template name="loading-indicator">
        <div class="loading" data-ametys-dashboard-role="loading" style="display: none"></div>
    </xsl:template>
    
</xsl:stylesheet>
