<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
    xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
    xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
    exclude-result-prefixes="ametys resolver">

    <xsl:import href="view://stylesheets/forms/helper/entry-information.xsl"/>

    <xsl:variable name="cssPrefix">entry-form-fields</xsl:variable>

    <xsl:template match="/entry">
        <dl class="{$cssPrefix}">
            <xsl:apply-templates select="field"/>
        </dl>
    </xsl:template>
    
    <xsl:template match="field">
        <div class="{$cssPrefix}__item">
            <xsl:apply-templates select="." mode="display-label"/>   
            <xsl:apply-templates select="." mode="display-value"/>    
        </div>
    </xsl:template>
    
    <xsl:template match="field" mode="display-label">
        <dt class="{$cssPrefix}__item_label">
            <xsl:value-of select="@label"/>
        </dt>
    </xsl:template>
    
    <xsl:template match="field" mode="display-value">
        <dd class="{$cssPrefix}__item_value {translate(@type, $uppercase, $lowercase)}">
            <xsl:choose>
                <xsl:when test="value">
                    <xsl:apply-templates select="." mode="value"/>    
                </xsl:when>
                <xsl:otherwise>
                    <i18n:text i18n:key="PLUGINS_FORMS_SERVICE_DASHBOARD_ENTRY_EMPTY_VALUE" i18n:catalogue="plugin.forms"/>
                </xsl:otherwise>
            </xsl:choose>
        </dd>
    </xsl:template>
    
    <xsl:template match="field[@typeId='form.ChoicesList']" mode="display-value">
        <dd class="{$cssPrefix}__item_value {translate(@type, $uppercase, $lowercase)}">
            <xsl:choose>
                <xsl:when test="additional-infos/values/value">
                    <xsl:apply-templates select="." mode="value"/>    
                </xsl:when>
                <xsl:otherwise>
                    <i18n:text i18n:key="PLUGINS_FORMS_SERVICE_DASHBOARD_ENTRY_EMPTY_VALUE" i18n:catalogue="plugin.forms"/>
                </xsl:otherwise>
            </xsl:choose>
        </dd>
    </xsl:template>
    
</xsl:stylesheet>
