<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:stringutils="org.ametys.core.util.StringUtils"
                xmlns:exslt="http://exslt.org/common"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
                extension-element-prefixes="ametys stringutils">
    
    <xsl:param name="contextPath" />
    <xsl:param name="cms-context" />
    <xsl:param name="plugin" />
    <xsl:param name="site" />
    <xsl:param name="locale" />
    
    <xsl:variable name="decimal-separator">
        <xsl:choose>
            <xsl:when test="$locale = 'fr' or $locale ='fr_FR'">,</xsl:when>
            <xsl:otherwise>.</xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    
    <xsl:template match="/form">
        <html>
            <head />
            <body>
                <xsl:call-template name="entry-count"/>
                <br />
                <xsl:apply-templates select="question"/>
            </body>
        </html>
    </xsl:template>
    
    <xsl:template name="entry-count">
        <xsl:variable name="count">  <xsl:value-of select="@entries-count" /></xsl:variable>
        <div>
            <i18n:text i18n:key="PLUGINS_FORMS_STATISTICS_GLOBAL_TEXT_1"/>
            <xsl:value-of select="@entries-count" />
            <xsl:choose>
                <xsl:when test="$count &gt; 1">
                    <i18n:text i18n:key="PLUGINS_FORMS_STATISTICS_GLOBAL_TEXT_MULTIPLE"/>
                </xsl:when>
                <xsl:otherwise>
                    <i18n:text i18n:key="PLUGINS_FORMS_STATISTICS_GLOBAL_TEXT_SINGLE"/>
                </xsl:otherwise>
            </xsl:choose>
            
        </div>
    </xsl:template>
    
    <xsl:template match="question">
        <table>
            <thead>
                <xsl:apply-templates select="." mode="header"/>
            </thead>
            <tbody>
                <xsl:apply-templates select="." mode="body"/>
            </tbody>
        </table>
        
        <!-- Empty row between tables -->
        <br />
    </xsl:template>
    
    <xsl:template match="question[@type = 'form.Matrix']" mode ="header">
        <tr>
            <xsl:call-template name="question-header-title" />
            <xsl:apply-templates select="values/options[1]/option" mode="header" />
        </tr>
    </xsl:template>
    
    <xsl:template match="question" mode ="header">
        <tr>
            <xsl:call-template name="question-header-title" />
            <td>
                <i18n:text i18n:key="PLUGINS_FORMS_STATISTICS_CHOICE_COUNT"/>
            </td>
            <td>
                <i18n:text i18n:key="PLUGINS_FORMS_STATISTICS_CHOICE_PERCENT"/>
            </td>
        </tr>
    </xsl:template>
    
    <xsl:template name="question-header-title">
        <th style="text-align: left">
            <xsl:value-of select="stringutils:sanitizeXlsHtml(@title)" />
        </th>
    </xsl:template>
    
    <xsl:template match="option" mode="header">
        <th colspan="2">
            <xsl:value-of select="stringutils:sanitizeXlsHtml(@label)" />
        </th>
    </xsl:template>
    
    <xsl:template match="question[@type = 'form.Matrix']" mode ="body">
        <xsl:for-each select="values/options">
            <tr>
                <td>
                    <xsl:value-of select="stringutils:sanitizeXlsHtml(@label)" />
                </td>
                <xsl:for-each select="option">
                    <xsl:call-template name="output-choice-values"><xsl:with-param name="count" select="@count" /></xsl:call-template>
                </xsl:for-each>
            </tr>
        </xsl:for-each>
    </xsl:template>
    
    <xsl:template match="question[@type = 'form.ChoicesList']" mode ="body">
        <xsl:apply-templates select="values/option" mode="question-choice" />
    </xsl:template>
    
    <xsl:template match="option" mode="question-choice">
        <tr>
            <td>
                <xsl:choose>
                    <xsl:when test="@label = '__internal_other'">
                        <i18n:text i18n:key="PLUGINS_FORMS_STATISTICS_OTHER_OPTION"/>
                    </xsl:when>
                    <xsl:when test="@label = '__internal_not_answered'">
                        <i18n:text i18n:key="PLUGINS_FORMS_STATISTICS_NOT_ANSWERED"/>
                    </xsl:when>
                    <xsl:otherwise>
		                <xsl:value-of select="stringutils:sanitizeXlsHtml(@label)" />
                    </xsl:otherwise>
                </xsl:choose>
            </td>
            <xsl:call-template name="output-choice-values"><xsl:with-param name="count" select="@count" /></xsl:call-template>
        </tr>
    </xsl:template>
    
    <xsl:template match="question[@type = 'form.Checkbox']" mode ="body">
        <tr>
            <td>
                <i18n:text i18n:key="PLUGINS_FORMS_STATISTICS_TRUE" />
            </td>
            <xsl:call-template name="output-choice-values"><xsl:with-param name="count" select="values/@true" /></xsl:call-template>
        </tr>
        <tr>
            <td>
                <i18n:text i18n:key="PLUGINS_FORMS_STATISTICS_FALSE" />
            </td>
            <xsl:call-template name="output-choice-values"><xsl:with-param name="count" select="values/@false" /></xsl:call-template>
        </tr>
    </xsl:template>
    
    <xsl:template match="question" mode ="body">
        <tr>
            <td>
                <i18n:text i18n:key="PLUGINS_FORMS_STATISTICS_ANSWERED" />
            </td>
            <xsl:call-template name="output-choice-values"><xsl:with-param name="count" select="values/@answered" /></xsl:call-template>
        </tr>
        <tr>
            <td>
                <i18n:text i18n:key="PLUGINS_FORMS_STATISTICS_NOT_ANSWERED" />
            </td>
            <xsl:call-template name="output-choice-values"><xsl:with-param name="count" select="values/@empty" /></xsl:call-template>
        </tr>
    </xsl:template>
    
    <xsl:template name="output-choice-values">
        <xsl:param name="count" />
        
        <td style='mso-number-format:"0"'>
            <xsl:value-of select="$count" />
        </td>
        <td style='mso-number-format:"Percent"'>
            <xsl:value-of select="translate($count div /form/@entries-count, '.', $decimal-separator)" />
        </td>
    </xsl:template>
    
</xsl:stylesheet>