/*
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.forms.question.types.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.ametys.cms.data.type.ModelItemTypeConstants;
import org.ametys.plugins.forms.question.types.AbstractStaticFormQuestionType;
import org.ametys.plugins.forms.repository.Form;
import org.ametys.plugins.forms.repository.FormQuestion;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.SimpleViewItemGroup;
import org.ametys.runtime.model.ViewElement;
import org.ametys.runtime.model.ViewItemGroup;

/**
 * Class for creating rich text to insert in forms
 */
public class RichTextQuestionType extends AbstractStaticFormQuestionType
{
    /** Constant for rich text attribute. */
    public static final String ATTRIBUTE_RICH_TEXT = "rich-text";
    
    /** Constant for default title */
    public static final String DEFAULT_TITLE = "PLUGIN_FORMS_QUESTION_DEFAULT_TITLE_RICH_TEXT";
    
    @Override
    protected List<ModelItem> _getModelItems()
    {
        List<ModelItem> modelItems = super._getModelItems();
        
        ElementDefinition textValue = _formElementDefinitionHelper.getElementDefinition(ATTRIBUTE_RICH_TEXT, ModelItemTypeConstants.RICH_TEXT_ELEMENT_TYPE_ID, "PLUGINS_FORMS_QUESTIONS_DIALOG_RICH_TEXT", "PLUGINS_FORMS_QUESTIONS_DIALOG_RICH_TEXT_DESC", null);
        Map<String, I18nizableText> widgetParameters  = new HashMap<>();
        widgetParameters.put("resizable", new I18nizableText("false"));
        textValue.setWidgetParameters(widgetParameters);
        modelItems.add(textValue);
        
        return modelItems;
    }
    
    @Override
    protected List<ViewItemGroup> _getTabs(Form form)
    {
        return List.of(_getMainTab(), _getRulesTab());
    }
    
    /**
     * Define the content of the main tab
     * @return the main tab definition
     */
    protected SimpleViewItemGroup _getMainTab()
    {
        SimpleViewItemGroup fieldset =  super._createMainTab();
        
        ViewElement title = new ViewElement();
        title.setDefinition((ElementDefinition< ? >) getModel().getModelItem(FormQuestion.ATTRIBUTE_TITLE));
        fieldset.addViewItem(title);
        
        ViewElement text = new ViewElement();
        text.setDefinition((ElementDefinition< ? >) getModel().getModelItem(ATTRIBUTE_RICH_TEXT));
        fieldset.addViewItem(text);
        
        return fieldset;
    }
    
    public String getStorageType(FormQuestion question)
    {
        throw new UnsupportedOperationException("Method getStorageType doesn't be called for richText question type");
    }
    
    @Override
    public boolean onlyForDisplay(FormQuestion question)
    {
        return true;
    }
    
    @Override
    public boolean canBeAnsweredByUser(FormQuestion question)
    {
        return false;
    }
    
    public I18nizableText getDefaultTitle()
    {
        return new I18nizableText("plugin.forms", DEFAULT_TITLE);
    }
    
    public Map<String, Object> getAnonymizedData(FormQuestion question)
    {
        return Map.of();
    }
}
