/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms;

import java.time.Period;
import java.time.ZonedDateTime;
import java.util.Map;
import org.ametys.core.trace.ForensicLogger;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.population.UserPopulationDAO;
import org.ametys.core.user.status.PersonalDataPolicy;
import org.ametys.core.user.status.UserStatusInfo;
import org.ametys.plugins.forms.repository.FormEntry;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectIterator;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.query.QueryHelper;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.UserExpression;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class FormEntryPersonalDataPolicy
extends AbstractLogEnabled
implements PersonalDataPolicy,
Serviceable,
Initializable {
    protected AmetysObjectResolver _resolver;
    private Period _delay;

    public void service(ServiceManager manager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
    }

    public void initialize() throws Exception {
        Long config = (Long)Config.getInstance().getValue("form.data.policy.form.entries.retention", false, null);
        this._delay = config != null && config >= 0L ? Period.ofMonths(config.intValue()) : null;
    }

    public PersonalDataPolicy.AnonymizationResult process(UserStatusInfo userStatusInfo) {
        if (this._delay != null && ZonedDateTime.now().isAfter(userStatusInfo.getMissingSinceDate().plus(this._delay))) {
            UserExpression userExpression = new UserExpression("ametys-user", Expression.Operator.EQ, userStatusInfo.getUserIdentity());
            String query = QueryHelper.getXPathQuery(null, (String)"ametys:form-entry", (Expression)userExpression);
            try (AmetysObjectIterable entries = this._resolver.query(query);){
                if (entries.getSize() > 0L) {
                    for (FormEntry entry : entries) {
                        entry.anonymize();
                    }
                    ForensicLogger.info((String)"data.policy.gdpr.anonymize.form.submissions", Map.of("handled", Long.toString(entries.getSize()), "identity", userStatusInfo.getUserIdentity()), (UserIdentity)UserPopulationDAO.SYSTEM_USER_IDENTITY);
                    AmetysObjectIterator ametysObjectIterator = PersonalDataPolicy.AnonymizationResult.PROCESSED;
                    return ametysObjectIterator;
                }
                PersonalDataPolicy.AnonymizationResult anonymizationResult = PersonalDataPolicy.AnonymizationResult.NO_DATA;
                return anonymizationResult;
            }
        }
        return PersonalDataPolicy.AnonymizationResult.TOO_EARLY;
    }
}

