/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.content.workflow;

import com.opensymphony.workflow.InvalidInputException;
import com.opensymphony.workflow.Workflow;
import com.opensymphony.workflow.WorkflowException;
import java.util.HashMap;
import java.util.Map;
import org.ametys.cms.repository.Content;
import org.ametys.cms.workflow.AbstractContentWorkflowComponent;
import org.ametys.core.cocoon.ActionResultGenerator;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.core.util.JSONUtils;
import org.ametys.plugins.forms.content.Form;
import org.ametys.plugins.forms.content.data.FieldValue;
import org.ametys.plugins.forms.content.data.UserEntry;
import org.ametys.plugins.forms.content.jcr.FormPropertiesManager;
import org.ametys.plugins.forms.content.table.FormTableManager;
import org.ametys.plugins.workflow.AbstractWorkflowComponent;
import org.ametys.plugins.workflow.cocoon.WorkflowAction;
import org.ametys.plugins.workflow.store.JdbcWorkflowStore;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.commons.collections.MapUtils;

public class FormEntriesWorkflowAction
extends WorkflowAction {
    private FormPropertiesManager _formPropertiesManager;
    private FormTableManager _formTableManager;
    private CurrentUserProvider _currentUserProvider;
    private UserManager _userManager;
    private JSONUtils _jsonUtils;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._formPropertiesManager = (FormPropertiesManager)((Object)serviceManager.lookup(FormPropertiesManager.ROLE));
        this._formTableManager = (FormTableManager)((Object)serviceManager.lookup(FormTableManager.ROLE));
        this._currentUserProvider = (CurrentUserProvider)serviceManager.lookup(CurrentUserProvider.ROLE);
        this._userManager = (UserManager)serviceManager.lookup(UserManager.ROLE);
        this._jsonUtils = (JSONUtils)serviceManager.lookup(JSONUtils.ROLE);
    }

    protected Map _act(Redirector redirector, Map objectModel, String source, Parameters parameters, int actionId, Map inputs) throws InvalidInputException, WorkflowException {
        Workflow workflow = this._workflowProvider.getExternalWorkflow(JdbcWorkflowStore.ROLE);
        workflow.doAction(this._getWorkflowId(objectModel, source, parameters), actionId, inputs);
        return this._getActionResult(redirector, objectModel, source, parameters);
    }

    protected long _getWorkflowId(Map objectModel, String source, Parameters parameters) {
        try {
            String entryId = parameters.getParameter("entryId");
            String formId = parameters.getParameter("formId");
            Form form = this._formPropertiesManager.getForm(formId);
            UserEntry submission = this._formTableManager.getSubmission(form, new HashMap<String, FieldValue>(), Integer.valueOf(entryId));
            if (submission == null) {
                throw new RuntimeException("Unable to retrieve the workflow id for the entry '" + entryId + "' of the form '" + formId + "'.");
            }
            return submission.getWorkflowId().intValue();
        }
        catch (Exception e) {
            throw new RuntimeException("Missing parameter workflowId", e);
        }
    }

    protected Map<String, Object> _getInputs(Redirector redirector, Map objectModel, String source, Parameters parameters) throws Exception {
        Map inputs = super._getInputs(redirector, objectModel, source, parameters);
        String formId = parameters.getParameter("formId");
        Content formContent = this._formPropertiesManager.getFormContent(formId);
        inputs.put(AbstractContentWorkflowComponent.CONTENT_KEY, formContent);
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        HashMap result = new HashMap();
        request.setAttribute(ActionResultGenerator.MAP_REQUEST_ATTR, result);
        inputs.put(AbstractWorkflowComponent.RESULT_MAP_KEY, result);
        String comment = request.getParameter("comment");
        inputs.put("comment", comment);
        String sendMailAsJSON = request.getParameter("sendMailInfo");
        Map sendMailInfo = this._jsonUtils.convertJsonToMap(sendMailAsJSON);
        if (MapUtils.isNotEmpty((Map)sendMailInfo)) {
            UserIdentity userIdentity = this._currentUserProvider.getUser();
            User user = this._userManager.getUser(userIdentity.getPopulationId(), userIdentity.getLogin());
            inputs.put("sender", user.getEmail());
            inputs.put("recipient", sendMailInfo.get("recipient"));
            inputs.put("subject", sendMailInfo.get("subject"));
            inputs.put("body", sendMailInfo.get("body"));
        } else {
            inputs.put("send-request-information-mail", "false");
        }
        return inputs;
    }
}

