/*
 *  Copyright 2016 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * @private
 * This class control a ribbon menu representing the workflow state of the form entry.
 */
Ext.define('Ametys.plugins.forms.workflow.AbstractFormEntriesWorkflowMenu', {
	extend: 'Ametys.plugins.cms.content.controller.WorkflowMenu',

    workflowItems: 'entries',
    
    /**
     * @protected
     * Get form entry target type
     */
    getFormEntryTargetType : function()
    {
        // To implement
        return null;
    },
    
	areSameTargets: function (target1, target2)
	{
        if (!this.callParent(arguments))
        {
            return false;
        }
        
		var subtargets1 = target1.getSubtargets(),
		    subtargets2 = target2.getSubtargets();
		
		return this._areSameTargetsArray(subtargets1, subtargets2, 1);
	},
	
	/**
	 * @private
	 * Get the state of the given targets
	 * @param targets The form entries targets
	 */
	_getWorkflowState: function (targets)
	{
        var workflowName = this.getInitialConfig("workflow-name");
        
        // Avoid workflow button to be updated if the content is not of the concerned workflow
        var matchingTargets = Ext.Array.filter(targets, function (target) {
            return target.getParameters().workflowName == workflowName;
        }, this);
        
        if (matchingTargets.length > 0)
        {
            this.disable();
        
            var entryTargets = matchingTargets[0].getSubtargets(this.getFormEntryTargetType());
            
            var entryIds = [];
            for (var i=0; i < entryTargets.length; i++)
            {
                entryIds.push(entryTargets[i].getParameters().id);
            }
            
            if (!Ext.isEmpty(entryIds))
            {
                this.serverCall ('getWorkflowState', [entryIds, matchingTargets[0].getParameters().id, this.getId()], Ext.bind(this._getWorkflowStateCb, this), {refreshing: true, errorMessage: true});
            }
            else
            {
                this.setDescription (this.getInitialConfig("description") + '<br/><br/>' + this.getInitialConfig("selection-description-nomatch"));
                this.toggle(false);
                this.disable();
            }
        }
        else
        {
            // There is no target matching the concerned workflow, hide button
            this._hide();
        }
	},
	
	/**
	 * @private
	 * Get the tooltip description according to workflow state of the current selection
	 * @param {String} description the initial text for the tooltip
	 * @param {Object} params the parameters sent out by the server
	 * @return {String} a more accurate description text
	 */
	_getTooltipDescription: function (description, params)
	{
		var entries = params.entries;
		var count = entries.length;
		if (count > 0)
		{
			if (description != "")
			{
				description += "<br/><br/>";
			}
			
			if (count == 1)
			{
				description += count + ' ' + this.getInitialConfig("entryselected-description");
			}
			else
			{
				description += count + ' ' + this.getInitialConfig("several-entryselected-description");
			}
		}
		
		return description;
	}
});
