<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2023 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:docbook="http://docbook.org/ns/docbook"
							  xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
							  xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
                              exclude-result-prefixes="docbook resolver i18n ametys">
                              
	<xsl:template match="computing-type[@xsl-enabled = 'true' and @id = 'computing.CurrentPageId']" mode ="render-js">
		<xsl:param name="title"/>
		<xsl:param name="name"/>

	</xsl:template>
	
	<xsl:template match="computing-type[@xsl-enabled = 'true' and @id = 'computing.CurrentPageId']" mode="render-html">
		<xsl:param name="title"/>
		<xsl:param name="name"/>
		<input type="hidden" name="{$name}" value="{ametys:pageId()}" />
	</xsl:template>
	
	<xsl:template match="computing-type[@xsl-enabled = 'true' and @id = 'computing.CurrentPageId']" mode="read-only-render-html">
        <xsl:param name="title"/>
        <xsl:param name="name"/>
        <xsl:param name="value"/>
        
        <div class="computed"> 
            <div class="label">
                <label for="{$name}_{$uniqueId}">
                    <xsl:value-of select="$title" />
                </label>
            </div>
            <div class="{$cssPrefix}__item_value">
                <a target="blank" href="{resolver:resolve('page', $value/additional-infos/page/id)}"><xsl:value-of select="$value/additional-infos/page/title"/></a>
           </div>
        </div>
    </xsl:template>
    
    <xsl:template match="computing-type[@xsl-enabled = 'true' and @id = 'computing.CurrentPageId']" mode ="render-mail">
        <xsl:param name="value"/>
        <a target="blank" href="{resolver:resolve('page', $value/additional-infos/page/id, false(), true())}"><xsl:value-of select="$value/additional-infos/page/title"/></a>
    </xsl:template>
    
</xsl:stylesheet>