/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.forms.question.types.impl;

import java.util.Collections;
import java.util.List;
import java.util.Map;

import org.ametys.plugins.forms.question.types.AbstractFormQuestionType;
import org.ametys.plugins.forms.repository.FormQuestion;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.SimpleViewItemGroup;
import org.ametys.runtime.model.ViewElement;
import org.ametys.runtime.model.type.ModelItemTypeConstants;

/**
 * Class for creating textarea questions
 */
public class TextAreaQuestionType extends AbstractFormQuestionType
{
    /** Constant for number of lines attribute. */
    public static final String ATTRIBUTE_LINE_NUMBER = "line-number";
    
    /** Constant for placeholder attribute. */
    public static final String ATTRIBUTE_PLACEHOLDER = "placeholder";

    /** Constant for default title */
    public static final String DEFAULT_TITLE = "PLUGIN_FORMS_QUESTION_DEFAULT_TITLE_TEXT_AREA";
    
    @Override
    protected List<ModelItem> _getModelItems()
    {
        List<ModelItem> modelItems = super._getModelItems();
        
        //PLACEHOLDER
        ElementDefinition placeholder = _formElementDefinitionHelper.getElementDefinition(ATTRIBUTE_PLACEHOLDER, ModelItemTypeConstants.STRING_TYPE_ID, "PLUGINS_FORMS_QUESTIONS_DIALOG_QUESTION_PLACEHOLDER", "PLUGINS_FORMS_QUESTIONS_DIALOG_QUESTION_PLACEHOLDER_DESC", null);
        modelItems.add(placeholder);
        
        ElementDefinition<Long> lineNb = _formElementDefinitionHelper.getElementDefinition(ATTRIBUTE_LINE_NUMBER, ModelItemTypeConstants.LONG_TYPE_ID, "PLUGINS_FORMS_QUESTIONS_DIALOG_TEXT_AREA_LINE_NUMBER", "PLUGINS_FORMS_QUESTIONS_DIALOG_TEXT_AREA_LINE_NUMBER_DESC", null);
        lineNb.setDefaultValue((long) 3);
        modelItems.add(lineNb);
        
        return modelItems;
    }
    
    @Override
    protected SimpleViewItemGroup _getAdvancedTab()
    {
        SimpleViewItemGroup advancedFieldset =  super._getAdvancedTab();
        
        ViewElement placeholder = new ViewElement();
        placeholder.setDefinition((ElementDefinition< ? >) getModel().getModelItem(ATTRIBUTE_PLACEHOLDER));
        advancedFieldset.addViewItem(placeholder);
        
        ViewElement lineNb = new ViewElement();
        lineNb.setDefinition((ElementDefinition< ? >) getModel().getModelItem(ATTRIBUTE_LINE_NUMBER));
        advancedFieldset.addViewItem(lineNb);
        
        return advancedFieldset;
    }

    public String getStorageType(FormQuestion question)
    {
        return ModelItemTypeConstants.STRING_TYPE_ID;
    }
    
    public I18nizableText getDefaultTitle()
    {
        return new I18nizableText("plugin.forms", DEFAULT_TITLE);
    }
    
    @Override
    public Map<String, Object> getAnonymizedData(FormQuestion question)
    {
        return Collections.singletonMap(question.getNameForForm(), isMandatory(question) ? "anonymized" : null);
    }
}
