/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.content.data;

import com.opensymphony.workflow.Workflow;
import com.opensymphony.workflow.loader.StepDescriptor;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import com.opensymphony.workflow.spi.Step;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;
import org.ametys.core.util.I18nUtils;
import org.ametys.plugins.forms.FormsException;
import org.ametys.plugins.forms.content.Field;
import org.ametys.plugins.forms.content.Form;
import org.ametys.plugins.forms.content.data.FieldValue;
import org.ametys.plugins.forms.content.data.UserEntry;
import org.ametys.plugins.forms.content.jcr.FormPropertiesManager;
import org.ametys.plugins.forms.content.table.FormTableManager;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.workflow.store.JdbcWorkflowStore;
import org.ametys.plugins.workflow.support.WorkflowProvider;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class FormEntriesGenerator
extends ServiceableGenerator {
    protected static final DateFormat _DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    protected static final I18nizableText __MESSAGE_NO_STEP = new I18nizableText("plugin.forms", "PLUGINS_FORMS_UITOOL_ENTRY_WORKFLOW_NO_WORKFLOW");
    protected FormPropertiesManager _formPropertiesManager;
    protected FormTableManager _formTableManager;
    protected AmetysObjectResolver _resolver;
    protected WorkflowProvider _workflowProvider;
    protected I18nUtils _i18nUtils;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._resolver = (AmetysObjectResolver)serviceManager.lookup(AmetysObjectResolver.ROLE);
        this._formPropertiesManager = (FormPropertiesManager)((Object)serviceManager.lookup(FormPropertiesManager.ROLE));
        this._formTableManager = (FormTableManager)((Object)serviceManager.lookup(FormTableManager.ROLE));
        this._workflowProvider = (WorkflowProvider)serviceManager.lookup(WorkflowProvider.ROLE);
        this._i18nUtils = (I18nUtils)serviceManager.lookup(I18nUtils.ROLE);
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        String siteName = this.parameters.getParameter("site", "");
        String formId = this.parameters.getParameter("id", "");
        int start = this.parameters.getParameterAsInteger("start", 0);
        int limit = this.parameters.getParameterAsInteger("limit", Integer.MAX_VALUE);
        if (StringUtils.isEmpty((CharSequence)siteName) || StringUtils.isEmpty((CharSequence)formId)) {
            throw new ProcessingException("The site name and form ID must be provided.");
        }
        try {
            Form form = this._formPropertiesManager.getForm(siteName, formId);
            if (form == null) {
                throw new ProcessingException("The form of ID '" + formId + " can't be found in the site '" + siteName + "'.");
            }
            Map<String, FieldValue> columns = this._formTableManager.getColumns(form);
            List<UserEntry> entries = this._formTableManager.getSubmissions(form, columns, start, limit, null);
            int totalSubmissions = this._formTableManager.getTotalSubmissions(form.getId());
            this.contentHandler.startDocument();
            AttributesImpl atts = new AttributesImpl();
            atts.addCDATAAttribute("id", form.getId());
            atts.addCDATAAttribute("label", form.getLabel());
            atts.addCDATAAttribute("total", String.valueOf(totalSubmissions));
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"form", (Attributes)atts);
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"columns");
            for (FieldValue column : columns.values()) {
                atts.clear();
                atts.addCDATAAttribute("id", column.getColumnName());
                atts.addCDATAAttribute("label", column.getField().getLabel());
                atts.addCDATAAttribute("type", column.getField().getType().toString());
                atts.addCDATAAttribute("field-name", column.getField().getName());
                Map<String, String> properties = column.getField().getProperties();
                if (properties.containsKey("regexptype")) {
                    atts.addCDATAAttribute("regexptype", properties.get("regexptype"));
                }
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"column", (Attributes)atts);
            }
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"columns");
            Workflow workflow = this._workflowProvider.getExternalWorkflow(JdbcWorkflowStore.ROLE);
            for (UserEntry entry : entries) {
                this._saxUserEntry(entry, workflow);
            }
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"form");
            this.contentHandler.endDocument();
        }
        catch (FormsException e) {
            throw new ProcessingException("An error occurred while getting the results of a form.", (Throwable)e);
        }
    }

    protected void _saxUserEntry(UserEntry entry, Workflow workflow) throws IOException, SAXException, ProcessingException {
        AttributesImpl atts = new AttributesImpl();
        atts.addCDATAAttribute("id", Integer.toString(entry.getId()));
        atts.addCDATAAttribute("submission-date", _DATE_FORMAT.format(entry.getCreationDate()));
        Integer workflowId = entry.getWorkflowId();
        if (workflowId != null) {
            this._saxWorkflowStep(atts, workflow, workflowId);
        } else {
            atts.addCDATAAttribute("workflowStep", this._i18nUtils.translate((I18nizable)__MESSAGE_NO_STEP));
        }
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"entry", (Attributes)atts);
        for (FieldValue fdValue : entry.getValues()) {
            atts.clear();
            atts.addCDATAAttribute("id", fdValue.getColumnName());
            String defaultValue = fdValue.getField().getProperties().get("value");
            if (StringUtils.trimToNull((String)fdValue.getField().getProperties().get("value")) != null) {
                atts.addCDATAAttribute("defaultvalue", defaultValue);
            }
            String displayValue = "";
            Object rawValue = fdValue.getValue();
            if (rawValue == null) {
                atts.addCDATAAttribute("null", "true");
            } else {
                displayValue = String.valueOf(rawValue);
                if (fdValue.getField().getType().equals((Object)Field.FieldType.SELECT) || fdValue.getField().getType().equals((Object)Field.FieldType.RADIO)) {
                    atts.addCDATAAttribute("value", String.valueOf(rawValue));
                    displayValue = this._formPropertiesManager.getDisplayValue(fdValue.getField(), String.valueOf(rawValue));
                }
            }
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"field", (Attributes)atts, (String)displayValue);
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"entry");
    }

    protected void _saxWorkflowStep(AttributesImpl attrs, Workflow workflow, int workflowId) {
        String workflowName = workflow.getWorkflowName((long)workflowId);
        Step step = (Step)workflow.getCurrentSteps((long)workflowId).iterator().next();
        WorkflowDescriptor workflowDescriptor = workflow.getWorkflowDescriptor(workflowName);
        int stepId = step.getStepId();
        attrs.addCDATAAttribute("workflowStepId", String.valueOf(stepId));
        StepDescriptor stepDescriptor = workflowDescriptor.getStep(stepId);
        I18nizableText workflowStepName = stepDescriptor == null ? __MESSAGE_NO_STEP : new I18nizableText("application", stepDescriptor.getName());
        attrs.addCDATAAttribute("workflowStep", this._i18nUtils.translate((I18nizable)workflowStepName));
        if ("application".equals(workflowStepName.getCatalogue())) {
            attrs.addCDATAAttribute("workflowStepIcon", "/plugins/cms/resources_workflow/" + workflowStepName.getKey() + "-small.png");
        } else {
            String pluginName = workflowStepName.getCatalogue().substring("plugin.".length());
            attrs.addCDATAAttribute("workflowStepIcon", "/plugins/" + pluginName + "/resources/img/workflow/" + workflowStepName.getKey() + "-small.png");
        }
    }
}

