/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.workflow;

import com.opensymphony.workflow.spi.Step;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.ametys.cms.workflow.AmetysObjectCheckRightsCondition;
import org.ametys.core.ui.Callable;
import org.ametys.core.ui.ClientSideElement;
import org.ametys.plugins.forms.repository.FormEntry;
import org.ametys.plugins.forms.workflow.AbstractFormEntriesWorkflowStepsClientSideElement;
import org.ametys.plugins.workflow.AbstractWorkflowComponent;
import org.ametys.plugins.workflow.repository.WorkflowAwareAmetysObject;
import org.ametys.plugins.workflow.support.WorkflowProvider;

public class FormEntryWorkflowStepsClientSideElement
extends AbstractFormEntriesWorkflowStepsClientSideElement {
    protected String _getDefaultMenuClassName() {
        return "Ametys.plugins.forms.workflow.FormEntryWorkflowMenu";
    }

    protected String _getDefaultActionClassName() {
        return "Ametys.plugins.forms.workflow.FormEntryWorkflowAction.doAction";
    }

    @Override
    protected List<ClientSideElement.ScriptFile> _getAdditionalScriptFiles() {
        ArrayList<ClientSideElement.ScriptFile> scriptFiles = new ArrayList<ClientSideElement.ScriptFile>();
        scriptFiles.add(new ClientSideElement.ScriptFile("/plugins/forms/resources/js/Ametys/plugins/forms/workflow/AbstractFormEntriesWorkflowAction.js"));
        scriptFiles.add(new ClientSideElement.ScriptFile("/plugins/forms/resources/js/Ametys/plugins/forms/workflow/FormEntryWorkflowAction.js"));
        scriptFiles.add(new ClientSideElement.ScriptFile("/plugins/forms/resources/js/Ametys/plugins/forms/workflow/AbstractFormEntriesWorkflowMenu.js"));
        scriptFiles.add(new ClientSideElement.ScriptFile("/plugins/forms/resources/js/Ametys/plugins/forms/workflow/FormEntryWorkflowMenu.js"));
        return scriptFiles;
    }

    protected String _getSelectionTargetId() {
        return "^(form-target)$";
    }

    @Override
    @Callable(rights={"Form_Entries_Rights_Data"}, rightContext="right.assignment.context.formsdirectoryaccess", paramIndex=1)
    public Map<String, Object> getWorkflowState(List<Object> entryIds, String formId, String scriptId) {
        ArrayList entries = new ArrayList();
        List formEntries = entryIds.stream().filter(String.class::isInstance).map(String.class::cast).map(this::_resolveEntry).collect(Collectors.toList());
        for (FormEntry entry : formEntries) {
            WorkflowProvider.AmetysObjectWorkflow workflow = this._workflowProvider.getAmetysObjectWorkflow((WorkflowAwareAmetysObject)entry);
            for (ClientSideElement.Script script : this._scripts) {
                if (!script.getId().equals(scriptId)) continue;
                HashMap<String, Object> entryMap = new HashMap<String, Object>();
                long workflowId = entry.getWorkflowId();
                List steps = workflow.getCurrentSteps(workflowId);
                ArrayList<Integer> stepIds = new ArrayList<Integer>();
                for (Step step : steps) {
                    stepIds.add(step.getStepId());
                }
                Integer workflowStepId = (Integer)script.getParameters().get("workflow-step");
                if (!stepIds.contains(workflowStepId)) continue;
                HashMap<String, Object> transientVars = new HashMap<String, Object>();
                transientVars.put(AmetysObjectCheckRightsCondition.AMETYS_OBJECT_KEY, (Object)entry);
                transientVars.put(AbstractWorkflowComponent.FAIL_CONDITIONS_KEY, new ArrayList());
                int[] availableActions = workflow.getAvailableActions(workflowId, transientVars);
                Arrays.sort(availableActions);
                ArrayList<Integer> activeActions = new ArrayList<Integer>();
                Iterator iterator = ((List)script.getParameters().get("workflow-actions-ids")).iterator();
                while (iterator.hasNext()) {
                    int actionId = (Integer)iterator.next();
                    if (Arrays.binarySearch(availableActions, actionId) < 0) continue;
                    activeActions.add(actionId);
                }
                entryMap.put("id", entry.getId());
                entryMap.put("actions", activeActions);
                entries.add(entryMap);
            }
        }
        HashMap<String, Object> results = new HashMap<String, Object>();
        results.put("entries", entries);
        return results;
    }

    private FormEntry _resolveEntry(String entryId) {
        return (FormEntry)this._resolver.resolveById(entryId);
    }
}

