<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
    xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
    xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper" 
    exclude-result-prefixes="ametys">

    <xsl:template match="question[@type = 'form.Checkbox']" mode="question-attribute-class">
        <xsl:attribute name="class">question question-boolean</xsl:attribute>
    </xsl:template>
    
    <xsl:template match="question[@type = 'form.Checkbox']" mode="field-attribute-class">
        <xsl:choose>
            <xsl:when test="@canWrite = 'true'">
                <xsl:attribute name="class">field field-checkbox</xsl:attribute>
            </xsl:when>
            <xsl:otherwise>
                <xsl:attribute name="class">field</xsl:attribute>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template match="question[@type = 'form.Checkbox']" mode="input-attribute-class">
        <xsl:attribute name="class">input input-checkbox</xsl:attribute>
    </xsl:template>
    
    <xsl:template match="question[@type = 'form.Checkbox']" mode="read-only-value">
        <xsl:param name="value" />
        
        <xsl:choose>
            <xsl:when test="$value = 'true'">
                <i18n:text i18n:key="PLUGINS_FORMS_SERVICE_DASHBOARD_ENTRY_BOOLEAN_TRUE" i18n:catalogue="plugin.forms"/>
            </xsl:when>
            <xsl:otherwise> <i18n:text i18n:key="PLUGINS_FORMS_SERVICE_DASHBOARD_ENTRY_BOOLEAN_FALSE" i18n:catalogue="plugin.forms"/></xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template match="question[@type = 'form.Checkbox']" mode="render-mail">
        <xsl:choose>
            <xsl:when test="value = 'true'">
                <i18n:text i18n:key="PLUGINS_FORMS_SERVICE_DASHBOARD_ENTRY_BOOLEAN_TRUE" i18n:catalogue="plugin.forms"/>
            </xsl:when>
            <xsl:otherwise> <i18n:text i18n:key="PLUGINS_FORMS_SERVICE_DASHBOARD_ENTRY_BOOLEAN_FALSE" i18n:catalogue="plugin.forms"/></xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template match="question[@type = 'form.Checkbox']" mode="input">
        <xsl:variable name="checked" select="is-checked and entry-value/value != 'true' or entry-value/value = 'true'"/>
        <input type="checkbox" name="{@name}" id="{@name}_{$uniqueId}" class="text">
            <xsl:if test="$checked = 'true'">
                <xsl:attribute name="checked">true</xsl:attribute>
            </xsl:if>
        </input>
    </xsl:template> 
    
    <xsl:template match="question[@type = 'form.Checkbox']" mode="init-rules">
        <xsl:variable name="questionName" select="@name"/>
        $j( document ).ready(function() {
            var canRead = <xsl:value-of select="@canRead"/>;
            var onChangeFunction = function(checkboxId) {
                 <xsl:for-each select="rules/rule">
                     var ruleTargetName = "<xsl:value-of select="@target-name"/>";
                     var ruleAction = "<xsl:value-of select="@action"/>";
                     var ruleValue = <xsl:value-of select="@value"/>;
                 
                     var initValue = $j('#' + checkboxId)[0].checked;
                     
                    
                     AmetysFormsHelper.onFormRuleActionChange("<xsl:value-of select="$uniqueId" />", ruleTargetName, ruleAction, initValue == ruleValue, canRead, <xsl:value-of select="$preview" />);
                 </xsl:for-each>
                 
                 FormListenersHelper.executeListenerForInputs("<xsl:value-of select="$uniqueId" />", "<xsl:value-of select="../@number" />");
            }
            var checkboxId = '<xsl:value-of select="$questionName"/>_<xsl:value-of select="$uniqueId"/>';
              
            // Do it at initialization
            onChangeFunction(checkboxId);
                    
            // Add change listener    
            $j('#' + checkboxId).on("change", function(){
                onChangeFunction(checkboxId);
            });
        });
    </xsl:template>
    
    <xsl:template match="question[@type = 'form.Checkbox' and mandatory = 'true']" mode="check-mandatory">
        var field = $j('#<xsl:value-of select="@name"/>_<xsl:value-of select="$uniqueId"/>')

        var parentField = $j('#form-<xsl:value-of select="$uniqueId"/>-q-<xsl:value-of select="@name"/>');
        if (!field.is(":checked") &amp;&amp; !field.is(":hidden") &amp;&amp; !field.prop('disabled') &amp;&amp; !parentField.hasClass("preview-hide"))
        {
            AmetysFormsHelper.addFormError('<xsl:value-of select="$uniqueId"/>', '<xsl:value-of select="@name"/>_<xsl:value-of select="$uniqueId"/>', '<xsl:value-of select="ametys:escapeJS(title)"/>', "<i18n:text i18n:key="PLUGINS_FORMS_PAGE_FORM_ERROR_MANDATORY"/>");
        }
    </xsl:template>
</xsl:stylesheet>