<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:docbook="http://docbook.org/ns/docbook"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1">
    
    <xsl:param name="contextPath" />
    <xsl:param name="cms-context" />
    <xsl:param name="plugin" />
    <xsl:param name="site" />
    <xsl:param name="lang" />
    <xsl:param name="isInQueue" />
    <xsl:param name="rankInQueue" />
    
    <xsl:template match="/ActionResult">
        <html>
            <head>
            </head>
            <body id="default">
                <div class="ametys-cms-service form-success">
                    <p class="message"><i18n:text i18n:key="PLUGINS_FORMS_RENDER_SUCCESS"/></p>
                    <xsl:if test="$isInQueue = 'true'">
                        <p class="message in-queue">
                            <i18n:translate>
                                 <i18n:text i18n:key="PLUGINS_FORMS_RENDER_QUEUE_SUCCESS" i18n:catalogue="plugin.forms"/>
                                 <i18n:param name="rank"><xsl:value-of select="$rankInQueue"/></i18n:param>
                             </i18n:translate>
                        </p>
                    </xsl:if>
                </div>
            </body>
        </html>
    </xsl:template>
    
</xsl:stylesheet>
