<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
    xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
    xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper" 
    exclude-result-prefixes="ametys">

    <xsl:import href="plugin:core://stylesheets/helper/text.xsl"/>

    <xsl:template match="question[@type = 'form.TextArea']" mode="question-attribute-class">
        <xsl:attribute name="class">question question-text multiple</xsl:attribute>
    </xsl:template>
    
    <xsl:template match="question[@type = 'form.TextArea']" mode="field-attribute-class">
        <xsl:attribute name="class">field field-textarea</xsl:attribute>
    </xsl:template>
    
    <xsl:template match="question[@type = 'form.TextArea']" mode="read-only-value">
        <xsl:param name="value" />
        
        <xsl:call-template name="text.nl2br">
            <xsl:with-param name="input" select="$value"/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template match="question[@type = 'form.TextArea']" mode="render-mail">
        <xsl:call-template name="text.nl2br">
            <xsl:with-param name="input" select="value"/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template match="question[@type = 'form.TextArea']" mode="input">
        <textarea name="{@name}" id="{@name}_{$uniqueId}" onchange="onTextAreaChangeFunction_{translate(@name, '-', '_')}_{$uniqueId}()">
            <xsl:attribute name="rows"><xsl:value-of select="line-number"/></xsl:attribute>
            <xsl:if test="placeholder">
                <xsl:attribute name="placeholder"><xsl:value-of select="placeholder"/></xsl:attribute>
            </xsl:if>
            <xsl:if test="mandatory = 'true'">
                <xsl:attribute name="aria-required">true</xsl:attribute>
            </xsl:if>
            <xsl:if test="entry-value/value">
                <xsl:value-of select="entry-value/value"/>
            </xsl:if>
        </textarea>
    </xsl:template>
    
    <xsl:template match="question[@type = 'form.TextArea']" mode="init-rules">
        function onTextAreaChangeFunction_<xsl:value-of select="translate(@name, '-', '_')" />_<xsl:value-of select="$uniqueId" />() {
            FormListenersHelper.executeListenerForInputs("<xsl:value-of select="$uniqueId" />", "<xsl:value-of select="../@number" />");
        }
    </xsl:template>
</xsl:stylesheet>