/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.content;

import java.util.List;
import org.ametys.cms.repository.Content;
import org.ametys.plugins.forms.content.Form;
import org.ametys.plugins.forms.content.FormManager;
import org.ametys.plugins.forms.content.jcr.FormPropertiesManager;
import org.ametys.web.repository.content.SharedContent;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.site.Site;
import org.ametys.web.site.CopyUpdater;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;

public class FormsCopyUpdater
extends AbstractLogEnabled
implements CopyUpdater,
ThreadSafe,
Serviceable {
    private FormManager _formManager;
    private FormPropertiesManager _formPropertiesManager;

    public void service(ServiceManager smanager) throws ServiceException {
        this._formManager = (FormManager)((Object)smanager.lookup(FormManager.ROLE));
        this._formPropertiesManager = (FormPropertiesManager)((Object)smanager.lookup(FormPropertiesManager.ROLE));
    }

    public void updateContent(Site initialSite, Site createdSite, Content initialContent, Content createdContent) {
        if (createdContent instanceof SharedContent) {
            return;
        }
        try {
            boolean needProcess = !this._formPropertiesManager.getForms(initialContent).isEmpty();
            List<Form> forms = this._formPropertiesManager.getForms(createdContent);
            for (Form form : forms) {
                this._formPropertiesManager.remove(form, createdContent);
                needProcess = true;
            }
            if (needProcess) {
                this._formManager.processContentForms(createdContent);
            }
        }
        catch (Exception e) {
            this.getLogger().warn("[Site copy] Unable to update forms for content '" + createdContent.getId() + "'", (Throwable)e);
        }
    }

    public void updatePage(Site initialSite, Site createdSite, Page page) {
    }

    public void updateSite(Site initialSite, Site createdSite) {
    }
}

