/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.content.data;

import com.opensymphony.workflow.Workflow;
import com.opensymphony.workflow.loader.StepDescriptor;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import com.opensymphony.workflow.spi.Step;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ametys.cms.repository.Content;
import org.ametys.core.cocoon.JSonReader;
import org.ametys.core.right.RightManager;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.DateUtils;
import org.ametys.core.util.I18nUtils;
import org.ametys.plugins.core.user.UserHelper;
import org.ametys.plugins.forms.FormsException;
import org.ametys.plugins.forms.content.Field;
import org.ametys.plugins.forms.content.Form;
import org.ametys.plugins.forms.content.data.FieldValue;
import org.ametys.plugins.forms.content.data.UserEntry;
import org.ametys.plugins.forms.content.jcr.FormPropertiesManager;
import org.ametys.plugins.forms.content.table.FormTableManager;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.workflow.store.JdbcWorkflowStore;
import org.ametys.plugins.workflow.support.WorkflowProvider;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.commons.lang3.StringUtils;

public class GetFormEntriesAction
extends ServiceableAction {
    protected static final Pattern __OPTION_VALUE_PATTERN = Pattern.compile("^option-([0-9]+)-value$");
    protected static final I18nizableText __MESSAGE_NO_STEP = new I18nizableText("plugin.forms", "PLUGINS_FORMS_UITOOL_ENTRY_WORKFLOW_NO_WORKFLOW");
    protected FormPropertiesManager _formPropertiesManager;
    protected FormTableManager _formTableManager;
    protected AmetysObjectResolver _resolver;
    protected WorkflowProvider _workflowProvider;
    protected I18nUtils _i18nUtils;
    protected UserHelper _userHelper;
    protected RightManager _rightManager;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._resolver = (AmetysObjectResolver)smanager.lookup(AmetysObjectResolver.ROLE);
        this._formPropertiesManager = (FormPropertiesManager)((Object)smanager.lookup(FormPropertiesManager.ROLE));
        this._formTableManager = (FormTableManager)((Object)smanager.lookup(FormTableManager.ROLE));
        this._workflowProvider = (WorkflowProvider)smanager.lookup(WorkflowProvider.ROLE);
        this._i18nUtils = (I18nUtils)smanager.lookup(I18nUtils.ROLE);
        this._userHelper = (UserHelper)smanager.lookup(UserHelper.ROLE);
        this._rightManager = (RightManager)smanager.lookup(RightManager.ROLE);
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        Map jsParameters = (Map)objectModel.get("parent-context");
        String siteName = (String)jsParameters.get("siteName");
        String contentId = (String)jsParameters.get("contentId");
        String formId = (String)jsParameters.get("id");
        int start = jsParameters.containsKey("start") ? (Integer)jsParameters.get("start") : 0;
        int limit = jsParameters.containsKey("limit") ? (Integer)jsParameters.get("limit") : Integer.MAX_VALUE;
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> entries2json = new ArrayList<Map<String, Object>>();
        Content content = (Content)this._resolver.resolveById(contentId);
        if (this._rightManager.currentUserHasReadAccess((Object)content)) {
            Form form = this._formPropertiesManager.getForm(siteName, formId);
            if (form == null) {
                throw new ProcessingException("The form of ID '" + formId + " can't be found in the site '" + siteName + "'.");
            }
            Workflow workflow = this._workflowProvider.getExternalWorkflow(JdbcWorkflowStore.ROLE);
            try {
                Map<String, FieldValue> columns = this._formTableManager.getColumns(form);
                List<UserEntry> entries = this._formTableManager.getSubmissions(form, columns, start, limit, null);
                int totalSubmissions = this._formTableManager.getTotalSubmissions(form.getId());
                result.put("id", form.getId());
                result.put("label", form.getLabel());
                result.put("total", totalSubmissions);
                for (UserEntry entry : entries) {
                    entries2json.add(this._entry2json(entry, workflow));
                }
            }
            catch (FormsException e) {
                this.getLogger().error("Failed to get SQL table for form '" + form.getId() + "' for content of id.", (Throwable)e);
            }
        }
        result.put("entries", entries2json);
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        request.setAttribute(JSonReader.OBJECT_TO_READ, result);
        return EMPTY_MAP;
    }

    private Map<String, Object> _entry2json(UserEntry entry, Workflow workflow) {
        UserIdentity userIdentity;
        HashMap<String, Object> entryAsMap = new HashMap<String, Object>();
        entryAsMap.put("id", entry.getId());
        entryAsMap.put("submission-date", DateUtils.dateToString((Date)entry.getCreationDate()));
        if (entry.getWorkflowId() != null) {
            entryAsMap.put("workflowStep", this._workflow2json(entry, workflow));
        }
        if ((userIdentity = entry.getUserIdentity()) != null) {
            entryAsMap.put("user", this._userHelper.user2json(userIdentity, true));
        }
        for (FieldValue fdValue : entry.getValues()) {
            Object rawValue = fdValue.getValue();
            if (rawValue == null) continue;
            entryAsMap.put(fdValue.getColumnName() + "_raw", rawValue);
            entryAsMap.put(fdValue.getColumnName(), this._getReadableValue(fdValue.getField(), rawValue));
        }
        return entryAsMap;
    }

    private Map<String, Object> _workflow2json(UserEntry entry, Workflow workflow) {
        LinkedHashMap<String, Object> workflowInfos = new LinkedHashMap<String, Object>();
        int currentStepId = 0;
        long workflowId = entry.getWorkflowId().intValue();
        for (Step step : workflow.getCurrentSteps(workflowId)) {
            currentStepId = step.getStepId();
        }
        String workflowName = workflow.getWorkflowName(workflowId);
        WorkflowDescriptor workflowDescriptor = workflow.getWorkflowDescriptor(workflowName);
        StepDescriptor stepDescriptor = workflowDescriptor.getStep(currentStepId);
        if (stepDescriptor != null) {
            String[] icons;
            I18nizableText workflowStepName = new I18nizableText("application", stepDescriptor.getName());
            workflowInfos.put("stepId", currentStepId);
            workflowInfos.put("name", workflowStepName);
            for (String icon : icons = new String[]{"small", "medium", "large"}) {
                if ("application".equals(workflowStepName.getCatalogue())) {
                    workflowInfos.put(icon + "Icon", "/plugins/cms/resources_workflow/" + workflowStepName.getKey() + "-" + icon + ".png");
                    continue;
                }
                String pluginName = workflowStepName.getCatalogue().substring("plugin.".length());
                workflowInfos.put(icon + "Icon", "/plugins/" + pluginName + "/resources/img/workflow/" + workflowStepName.getKey() + "-" + icon + ".png");
            }
        }
        return workflowInfos;
    }

    protected String _getReadableValue(Field field, Object value) {
        if (field.getType().equals((Object)Field.FieldType.SELECT) || field.getType().equals((Object)Field.FieldType.RADIO)) {
            Map<String, String> properties = field.getProperties();
            for (String key : properties.keySet()) {
                String index;
                String label;
                Matcher matcher = __OPTION_VALUE_PATTERN.matcher(key);
                if (!matcher.matches() || !StringUtils.trim((String)((String)value)).equals(StringUtils.trim((String)properties.get(key))) || !StringUtils.isNotEmpty(label = properties.containsKey("option-" + (index = matcher.group(1)) + "-label") ? properties.get("option-" + index + "-label") : null)) continue;
                return label;
            }
        }
        return Optional.ofNullable(value).map(Object::toString).orElse(null);
    }
}

