/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.helper;

import jakarta.mail.MessagingException;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.ametys.cms.data.File;
import org.ametys.core.ui.Callable;
import org.ametys.core.ui.mail.StandardMailBodyHelper;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.core.util.I18nUtils;
import org.ametys.core.util.mail.SendMailHelper;
import org.ametys.plugins.forms.dao.FormDAO;
import org.ametys.plugins.forms.dao.FormEntryDAO;
import org.ametys.plugins.forms.dao.FormQuestionDAO;
import org.ametys.plugins.forms.helper.FormAdminMailsHelper;
import org.ametys.plugins.forms.question.FormQuestionType;
import org.ametys.plugins.forms.question.sources.ChoiceSourceType;
import org.ametys.plugins.forms.question.sources.ManualWithEmailSourceType;
import org.ametys.plugins.forms.question.sources.UsersSourceType;
import org.ametys.plugins.forms.question.types.impl.ChoicesListQuestionType;
import org.ametys.plugins.forms.question.types.impl.FileQuestionType;
import org.ametys.plugins.forms.question.types.impl.SimpleTextQuestionType;
import org.ametys.plugins.forms.repository.Form;
import org.ametys.plugins.forms.repository.FormEntry;
import org.ametys.plugins.forms.repository.FormQuestion;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.site.Site;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;

public class FormMailHelper
extends AbstractLogEnabled
implements Serviceable,
Component,
Contextualizable {
    public static final String ROLE = FormMailHelper.class.getName();
    public static final String READ_RESTRICTION_ENABLE = "read-restriction-enable";
    public static final String RECEIVER_COMBOBOX_ENTRY_USER_VALUE = "entry-user";
    public static final String RECEIVER_COMBOBOX_INPUT_ONLY = "input-only";
    public static final String IGNORE_RIGHT_KEY = "ignore-right";
    protected static final String _FORM_ENTRY_PATTERN = "{form}";
    protected AmetysObjectResolver _resolver;
    protected I18nUtils _i18nUtils;
    protected UserManager _userManager;
    protected SourceResolver _sourceResolver;
    protected Context _context;
    protected FormDAO _formDAO;
    protected FormQuestionDAO _formQuestionDAO;
    protected FormEntryDAO _formEntryDAO;
    protected FormAdminMailsHelper _formAdminMailsHelper;

    public void service(ServiceManager manager) throws ServiceException {
        this._sourceResolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._i18nUtils = (I18nUtils)manager.lookup(I18nUtils.ROLE);
        this._userManager = (UserManager)manager.lookup(UserManager.ROLE);
        this._formDAO = (FormDAO)((Object)manager.lookup(FormDAO.ROLE));
        this._formQuestionDAO = (FormQuestionDAO)((Object)manager.lookup(FormQuestionDAO.ROLE));
        this._formEntryDAO = (FormEntryDAO)((Object)manager.lookup(FormEntryDAO.ROLE));
        this._formAdminMailsHelper = (FormAdminMailsHelper)((Object)manager.lookup(FormAdminMailsHelper.ROLE));
    }

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    @Callable(rights={"Plugins_Forms_Right_Handle"}, rightContext="right.assignment.context.formsdirectoryaccess", paramIndex=0)
    public Map<String, Object> getAvailableAdminReceiverFields(String formId) {
        ArrayList receiverfields = new ArrayList();
        for (FormQuestion question : this.getQuestionWithMail(formId)) {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("id", question.getNameForForm());
            properties.put("title", question.getTitle());
            receiverfields.add(properties);
        }
        return Map.of("data", receiverfields);
    }

    @Callable(rights={"Plugins_Forms_Right_Handle"}, rightContext="right.assignment.context.formsdirectoryaccess", paramIndex=0)
    public Map<String, Object> getAvailableReceiverFields(String formId) {
        Map<String, Object> results = this.getAvailableAdminReceiverFields(formId);
        List receiverfields = (List)results.get("data");
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("id", RECEIVER_COMBOBOX_ENTRY_USER_VALUE);
        properties.put("title", this._i18nUtils.translate((I18nizable)new I18nizableText("plugin.forms", "PLUGINS_FORMS_ACKNOWLEDGEMENT_RECEIPT_ENTRY_USER")));
        receiverfields.add(properties);
        return Map.of("data", receiverfields);
    }

    public List<FormQuestion> getQuestionWithMail(String formId) {
        ArrayList<FormQuestion> questions = new ArrayList<FormQuestion>();
        Form form = (Form)this._resolver.resolveById(formId);
        for (FormQuestion question : form.getQuestions()) {
            ChoicesListQuestionType cLType;
            FormQuestionType type = question.getType();
            if (type instanceof SimpleTextQuestionType) {
                if (!question.hasValue("regexp") || !question.getValue("regexp").equals("email")) continue;
                questions.add(question);
                continue;
            }
            if (!(type instanceof ChoicesListQuestionType) || !((cLType = (ChoicesListQuestionType)type).getSourceType(question) instanceof UsersSourceType) && !(cLType.getSourceType(question) instanceof ManualWithEmailSourceType)) continue;
            questions.add(question);
        }
        return questions;
    }

    public String[] getAdminEmails(Form form, FormEntry entry) {
        Optional<String[]> adminEmails = form.getAdminEmails();
        Optional<String> otherAdminEmails = form.getOtherAdminEmails();
        Object[] emailsAsArray = adminEmails.isPresent() ? adminEmails.get() : ArrayUtils.EMPTY_STRING_ARRAY;
        Optional<String> otherEmailSource = this.getReceiver(entry, otherAdminEmails);
        Object[] mergedEmails = emailsAsArray;
        if (otherEmailSource.isPresent()) {
            String otherEmails = otherEmailSource.get();
            String[] emails = otherEmails.split("[ ,;\r]");
            List<String> validEmails = this._formAdminMailsHelper.getValidAdminEmails(emails);
            if (!validEmails.isEmpty()) {
                mergedEmails = (String[])ArrayUtils.addAll((Object[])emailsAsArray, (Object[])validEmails.toArray(new String[validEmails.size()]));
            } else {
                this.getLogger().error("Mails addresses " + otherEmails + " did not match regex");
            }
        }
        return mergedEmails;
    }

    public Optional<String> getReceiver(FormEntry entry, Optional<String> receiverPath) {
        if (receiverPath.isEmpty()) {
            return Optional.empty();
        }
        if (receiverPath.get().equals(RECEIVER_COMBOBOX_ENTRY_USER_VALUE)) {
            UserIdentity userIdentity = entry.getUser();
            User user = this._userManager.getUser(userIdentity);
            return Optional.ofNullable(user != null ? user.getEmail() : null);
        }
        FormQuestion question = entry.getForm().getQuestion(receiverPath.get());
        FormQuestionType type = question.getType();
        if (type instanceof SimpleTextQuestionType) {
            return Optional.ofNullable((String)entry.getValue(receiverPath.get()));
        }
        if (type instanceof ChoicesListQuestionType) {
            ChoicesListQuestionType cLType = (ChoicesListQuestionType)type;
            if (cLType.getSourceType(question) instanceof UsersSourceType && !entry.isMultiple(receiverPath.get())) {
                UserIdentity userIdentity = (UserIdentity)entry.getValue(receiverPath.get());
                if (userIdentity != null) {
                    User user = this._userManager.getUser(userIdentity);
                    return user != null ? Optional.ofNullable(user.getEmail()) : Optional.empty();
                }
            } else {
                ChoiceSourceType userIdentity = cLType.getSourceType(question);
                if (userIdentity instanceof ManualWithEmailSourceType) {
                    ManualWithEmailSourceType manualWithEmail = (ManualWithEmailSourceType)userIdentity;
                    String value = (String)entry.getValue(receiverPath.get());
                    HashMap<String, Object> enumParam = new HashMap<String, Object>();
                    enumParam.put("question", (Object)question);
                    try {
                        return Optional.ofNullable(manualWithEmail.getEntryEmail(value, enumParam));
                    }
                    catch (Exception e) {
                        this.getLogger().error("Could not get email from question '" + question.getNameForForm() + "' with value '" + value + "'");
                    }
                }
            }
        }
        return Optional.empty();
    }

    public void sendEmailsForAdmin(Form form, FormEntry entry, String[] adminEmails) {
        try {
            String lang = (String)StringUtils.defaultIfBlank((CharSequence)form.getAdminEmailLanguage().orElse(null), (CharSequence)this._formDAO.getFormLocale(form));
            String sender = (String)Config.getInstance().getValue("smtp.mail.from");
            UserIdentity userIdentity = entry.getUser();
            User user = userIdentity != null ? this._userManager.getUser(userIdentity) : null;
            Optional<String> adminEmailSubject = form.getAdminEmailSubject();
            I18nizableText subject = adminEmailSubject.isPresent() ? this._replaceVariablesAndBreaks(form, user, adminEmailSubject.get(), lang) : null;
            Optional<String> adminEmailBody = form.getAdminEmailBody();
            I18nizableText message = adminEmailBody.isPresent() ? this._replaceVariablesAndBreaks(form, user, adminEmailBody.get(), lang) : null;
            String entryDetails = this.getMail("entry.html", entry, Map.of(), false);
            String prettyHtmlBody = StandardMailBodyHelper.newHTMLBody().withLanguage(lang).withTitle(subject).withMessage(message).withDetails(new I18nizableText("plugin.forms", "PLUGINS_FORMS_MAIL_RESULTS_DETAILS_TITLE"), entryDetails, false).build();
            String params = "?type=results&form-name=" + form.getTitle() + "&locale=" + lang;
            String text = this.getMail("results.txt" + params, entry, Map.of(), false);
            for (String email : adminEmails) {
                if (!StringUtils.isNotEmpty((CharSequence)email)) continue;
                this._sendMail(form, entry, this._i18nUtils.translate((I18nizable)subject, lang), prettyHtmlBody, text, sender, email, false, false);
            }
        }
        catch (IOException e) {
            this.getLogger().error("Error creating the notification message.", (Throwable)e);
        }
    }

    private I18nizableText _replaceVariablesAndBreaks(Form form, User user, String mailText, String language) {
        String text = mailText;
        text = StringUtils.replace((String)text, (String)"{site}", (String)form.getSite().getTitle());
        text = StringUtils.replace((String)text, (String)"{user}", (String)(user != null ? user.getFullName() : this._i18nUtils.translate((I18nizable)new I18nizableText("plugin.forms", "PLUGINS_FORMS_ADMIN_EMAILS_USER_ANONYMOUS"), language)));
        text = StringUtils.replace((String)text, (String)"{title}", (String)form.getTitle());
        text = text.replaceAll("\r?\n", "<br/>");
        return new I18nizableText(text);
    }

    public void sendLimitationReachedMailForAdmin(FormEntry entry, String[] adminEmails, LimitationMailType limitationType) {
        try {
            Form form = entry.getForm();
            String lang = (String)StringUtils.defaultIfBlank((CharSequence)form.getAdminEmailLanguage().orElse(null), (CharSequence)this._formDAO.getFormLocale(form));
            String sender = (String)Config.getInstance().getValue("smtp.mail.from");
            I18nizableText subject = limitationType == LimitationMailType.LIMIT ? new I18nizableText("plugin.forms", "PLUGINS_FORMS_MAIL_LIMIT_SUBJECT", List.of(form.getTitle(), form.getSite().getTitle())) : new I18nizableText("plugin.forms", "PLUGINS_FORMS_MAIL_QUEUE_SUBJECT", List.of(form.getTitle(), form.getSite().getTitle()));
            I18nizableText message = limitationType == LimitationMailType.LIMIT ? new I18nizableText("plugin.forms", "PLUGINS_FORMS_MAIL_LIMIT_TEXT", List.of(form.getTitle())) : new I18nizableText("plugin.forms", "PLUGINS_FORMS_MAIL_QUEUE_TEXT", List.of(form.getTitle()));
            String prettyHtmlBody = StandardMailBodyHelper.newHTMLBody().withLanguage(lang).withTitle(subject).withMessage(message).build();
            I18nizableText textI18n = limitationType == LimitationMailType.LIMIT ? new I18nizableText("plugin.forms", "PLUGINS_FORMS_MAIL_LIMIT_TEXT_NO_HTML", List.of(form.getTitle())) : new I18nizableText("plugin.forms", "PLUGINS_FORMS_MAIL_QUEUE_TEXT_NO_HTML", List.of(form.getTitle()));
            String text = this._i18nUtils.translate((I18nizable)textI18n, lang);
            for (String email : adminEmails) {
                if (!StringUtils.isNotEmpty((CharSequence)email)) continue;
                this._sendMail(form, entry, this._i18nUtils.translate((I18nizable)subject, lang), prettyHtmlBody, text, sender, email, false, false);
            }
        }
        catch (IOException e) {
            this.getLogger().error("Error creating the limit message.", (Throwable)e);
        }
    }

    public void sendReceiptEmail(Form form, FormEntry entry) {
        Optional<String> receiver;
        if (form.getReceiptSender().isPresent() && (receiver = this.getReceiver(entry, form.getReceiptReceiver())).isPresent()) {
            String lang = this._formDAO.getFormLocale(form);
            String sender = form.getReceiptSender().get();
            String subject = form.getReceiptSubject().get();
            String bodyTxt = form.getReceiptBody().get();
            String bodyHTML = bodyTxt.replaceAll("\r?\n", "<br/>");
            try {
                String prettyHtmlBody = StandardMailBodyHelper.newHTMLBody().withLanguage(lang).withTitle(subject).withMessage(bodyHTML).build();
                this._sendMail(form, entry, subject, prettyHtmlBody, bodyTxt, sender, receiver.get(), true, true);
            }
            catch (IOException e) {
                this.getLogger().error("An error occurred sending receipt mail to '{}'", (Object)receiver.get(), (Object)e);
            }
        }
    }

    public void sendOutOfQueueMail(Form form, FormEntry entry) {
        Optional<String> receiver = this.getReceiver(entry, form.getQueueMailReceiver());
        if (receiver.isPresent()) {
            String lang = this._formDAO.getFormLocale(form);
            String sender = form.getQueueMailSender().get();
            String subject = form.getQueueMailSubject().get();
            String bodyTxt = form.getQueueMailBody().get();
            String bodyHTML = bodyTxt.replaceAll("\r?\n", "<br/>");
            try {
                String prettyHtmlBody = StandardMailBodyHelper.newHTMLBody().withLanguage(lang).withTitle(subject).withMessage(bodyHTML).build();
                this._sendMail(form, entry, subject, prettyHtmlBody, bodyTxt, sender, receiver.get(), true, true);
            }
            catch (IOException e) {
                this.getLogger().error("An error occurred sending mail to get out of the queue to '{}'", (Object)receiver.get(), (Object)e);
            }
        }
    }

    public void sendInvitationMails(Form form, List<User> users, String message, String language) {
        String formLang = this._formDAO.getFormLocale(form);
        String lang = (String)StringUtils.defaultIfBlank((CharSequence)language, (CharSequence)formLang);
        String sender = (String)Config.getInstance().getValue("smtp.mail.from");
        I18nizableText subject = new I18nizableText("plugin.forms", "PLUGINS_FORMS_SEND_INVITATIONS_BOX_SUBJECT");
        Site site = form.getSite();
        String formURI = this._getFormURI(form, formLang);
        String replacedMessage = StringUtils.replace((String)message, (String)"{site}", (String)site.getTitle());
        String textMessage = StringUtils.replace((String)replacedMessage, (String)"{link}", (String)formURI);
        String htmlMessage = StringUtils.replace((String)replacedMessage, (String)"{link}", (String)("<a href='" + formURI + "'>" + formURI + "</a>"));
        for (User user : users) {
            try {
                String finalTextMessage = StringUtils.replace((String)textMessage, (String)"{name}", (String)user.getFullName());
                String finalHtmlMessage = StringUtils.replace((String)htmlMessage, (String)"{name}", (String)user.getFullName());
                String prettyHtmlBody = StandardMailBodyHelper.newHTMLBody().withLanguage(lang).withTitle(subject).withMessage(finalHtmlMessage).withLink(formURI, new I18nizableText("plugin.forms", "PLUGINS_FORMS_SEND_INVITATIONS_LINK_LABEL")).build();
                this._sendMail(form, null, this._i18nUtils.translate((I18nizable)subject, lang), prettyHtmlBody, finalTextMessage, sender, user.getEmail(), false, true);
            }
            catch (IOException e) {
                this.getLogger().error("Unable to send invitation mail to user {}", (Object)user.getEmail(), (Object)e);
            }
        }
    }

    protected String _getFormURI(Form form, String language) {
        Site site = form.getSite();
        Optional<Page> page = this._formDAO.getFormPage(form.getId(), site.getName()).stream().filter(Page.class::isInstance).map(Page.class::cast).filter(p -> p.getSitemapName().equals(language)).findAny();
        return page.map(p -> site.getUrl() + "/" + p.getSitemap().getName() + "/" + p.getPathInSitemap() + ".html").orElse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMail(String resource, FormEntry entry, Map<String, Object> additionalParameters, boolean withReadingRestriction) throws IOException {
        String string;
        Source src = null;
        Request request = ContextHelper.getRequest((Context)this._context);
        Form form = entry.getForm();
        try {
            request.setAttribute(IGNORE_RIGHT_KEY, (Object)true);
            String uri = "cocoon:/mail/entry/" + resource;
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("formId", form.getId());
            parameters.put("entryId", entry.getId());
            parameters.put(READ_RESTRICTION_ENABLE, withReadingRestriction);
            parameters.putAll(additionalParameters);
            src = this._sourceResolver.resolveURI(uri, null, parameters);
            InputStreamReader reader = new InputStreamReader(src.getInputStream(), "UTF-8");
            string = IOUtils.toString((Reader)reader);
        }
        catch (Throwable throwable) {
            request.setAttribute(IGNORE_RIGHT_KEY, (Object)false);
            this._sourceResolver.release(src);
            throw throwable;
        }
        request.setAttribute(IGNORE_RIGHT_KEY, (Object)false);
        this._sourceResolver.release(src);
        return string;
    }

    public Collection<SendMailHelper.NamedStream> getEntryFiles(Form form, FormEntry entry, boolean onlyWritableQuestion, boolean onlyReadableQuestion) {
        Optional<Long> currentStepId = entry.getForm().hasWorkflow() ? Optional.of(this._formEntryDAO.getCurrentStepId(entry)) : Optional.empty();
        return this._formQuestionDAO.getRuleFilteredQuestions(form, new FormQuestionDAO.FormEntryValues(null, entry), currentStepId, onlyWritableQuestion, onlyReadableQuestion).stream().filter(q -> q.getType() instanceof FileQuestionType).map(q -> (File)entry.getValue(q.getNameForForm())).filter(Objects::nonNull).map(f -> new SendMailHelper.NamedStream(f.getInputStream(), f.getName(), f.getMimeType())).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _sendMail(Form form, FormEntry entry, String subject, String html, String text, String sender, String recipient, boolean addFormInformation, boolean withReadingRestriction) {
        try {
            String htmlBody = html;
            String textBody = text;
            ArrayList records = entry != null ? this.getEntryFiles(form, entry, false, false) : new ArrayList();
            try {
                if (addFormInformation) {
                    if (textBody.contains(_FORM_ENTRY_PATTERN)) {
                        String entry2text = this.getMail("entry.txt", entry, Map.of(), withReadingRestriction);
                        textBody = StringUtils.replace((String)textBody, (String)_FORM_ENTRY_PATTERN, (String)entry2text);
                    }
                    if (htmlBody.contains(_FORM_ENTRY_PATTERN)) {
                        String entry2html = this.getMail("entry.html", entry, Map.of(), withReadingRestriction);
                        htmlBody = StringUtils.replace((String)htmlBody, (String)_FORM_ENTRY_PATTERN, (String)entry2html);
                    }
                }
                SendMailHelper.MailBuilder mailBuilder = SendMailHelper.newMail().withAsync(true).withSubject(subject).withHTMLBody(htmlBody).withTextBody(textBody).withSender(sender).withRecipient(recipient);
                if (!records.isEmpty()) {
                    mailBuilder = mailBuilder.withAttachmentsAsStream(records);
                }
                mailBuilder.sendMail();
            }
            finally {
                for (SendMailHelper.NamedStream record : records) {
                    IOUtils.close((Closeable)record.inputStream());
                }
            }
        }
        catch (MessagingException | IOException e) {
            this.getLogger().error("Error sending the mail to " + recipient, e);
        }
    }

    public static enum LimitationMailType {
        QUEUE,
        LIMIT;

    }
}

