/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class is the representation of a page.
 * @private
 */
Ext.define(
	"Ametys.plugins.forms.Page", 
	{
		config: {
			/**
			 * @cfg {String} id The unique id of the page
			 */
			/**
			 * @method getId Get the #cfg-id
			 * @return {String} The id
			 */
			/** @ignore */
			id: null,
			/**
			 * @cfg {String} title The title of the page
			 */
			/**
			 * @method getTitle Get the #cfg-title
			 * @return {String} The title
			 */
			/** @ignore */
			title: null,
			/**
             * @cfg {String} formId The page form id
             */
            /**
             * @method getFormId Get the #cfg-formId
             * @return {String} The page form id
             */
            /** @ignore */
            formId: null,
			/**
             * @cfg {Boolean} hasEntries true if the page form has at least one entry
             */
            /**
             * @method getHasEntries Get the #cfg-hasEntries
             * @return {Boolean} true if the page form has at least one entry
             */
            /** @ignore */
            hasEntries: false,
			/**
             * @cfg {Boolean} hasChildren true if the page has at least one question
             */
            /**
             * @method getHasChildren Get the #cfg-hasChildren
             * @return {Boolean} true if the page has at least one question
             */
            /** @ignore */
            hasChildren: false,
			/**
             * @cfg {Boolean} isConfigured True if the page is well configured
             */
            /**
             * @method getIsConfigured Get the #cfg-isConfigured
             * @return {Boolean} True if the page is well configured
             */
            /** @ignore */
            isConfigured: false,
            /**
             * @cfg {String[]} rights List of the id of the rights the current user have on this page
             */
            /**
             * @method getRights Get the #cfg-rights
             * @return {String[]} The rights
             */
            /** @ignore */
            rights: []
		},
		
		/**
		 * Creates a content instance
		 * @param {Object} config See configuration doc.
		 */
		constructor: function (config)
		{
			this.initConfig(config);
		},
		
		/**
		 * Get the page's properties
		 * @return {Object} initialProperty The initial page's properties
		 */
		getProperties: function (initialProperty)
		{
			initialProperty = initialProperty || {};
			
			return Ext.apply ({
					id: this._id,
					title: this._title,
                    formId: this._formId,
				    hasEntries: this._hasEntries,
                    hasChildren: this._hasChildren,
                    isConfigured: this._isConfigured,
                    rights: this._rights
                }, initialProperty
			);
		}
	}
);
