/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.question.validators;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.HashMap;
import org.ametys.plugins.forms.question.validators.AbstractIntervalFormValidator;
import org.ametys.runtime.i18n.I18nizableText;

public class LocalDateIntervalFormValidator
extends AbstractIntervalFormValidator<LocalDate> {
    public LocalDateIntervalFormValidator(String regexp, boolean mandatory, LocalDate min, LocalDate max) {
        super(regexp, mandatory, min, max);
    }

    @Override
    protected boolean isLessThan(LocalDate dateToValidate, LocalDate dateMin) {
        return dateToValidate.isBefore(dateMin);
    }

    @Override
    protected boolean isMoreThan(LocalDate dateToValidate, LocalDate dateMax) {
        return dateToValidate.isAfter(dateMax);
    }

    @Override
    protected I18nizableText getIntervalError(LocalDate min, LocalDate max) {
        HashMap<String, I18nizableText> i18nParams = new HashMap<String, I18nizableText>();
        i18nParams.put("startDate", new I18nizableText(min.format(DateTimeFormatter.ofLocalizedDate(FormatStyle.SHORT))));
        i18nParams.put("endDate", new I18nizableText(max.format(DateTimeFormatter.ofLocalizedDate(FormatStyle.SHORT))));
        return new I18nizableText("plugin.forms", "PLUGINS_FORMS_ENTRY_VALIDATOR_DATE_INTERVAL_ERROR", i18nParams);
    }
}

