/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.helper;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.ametys.core.right.RightManager;
import org.ametys.core.ui.Callable;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.plugins.forms.dao.FormDAO;
import org.ametys.plugins.forms.helper.FormMailHelper;
import org.ametys.plugins.forms.helper.LimitedEntriesHelper;
import org.ametys.plugins.forms.repository.Form;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.runtime.authentication.AccessDeniedException;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.web.repository.page.Page;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;

public class FormInvitationsHelper
extends AbstractLogEnabled
implements Serviceable,
Component {
    public static final String ROLE = FormInvitationsHelper.class.getName();
    protected AmetysObjectResolver _resolver;
    protected UserManager _userManager;
    protected RightManager _rightManager;
    protected LimitedEntriesHelper _limitedEntriesHelper;
    protected FormDAO _formDAO;
    protected FormMailHelper _formMailHelper;

    public void service(ServiceManager manager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._userManager = (UserManager)manager.lookup(UserManager.ROLE);
        this._rightManager = (RightManager)manager.lookup(RightManager.ROLE);
        this._limitedEntriesHelper = (LimitedEntriesHelper)((Object)manager.lookup(LimitedEntriesHelper.ROLE));
        this._formDAO = (FormDAO)((Object)manager.lookup(FormDAO.ROLE));
        this._formMailHelper = (FormMailHelper)((Object)manager.lookup(FormMailHelper.ROLE));
    }

    @Callable(rights={""})
    public Map<String, Object> sendInvitations(String formId, String message, String siteName, String language) {
        Form form = (Form)this._resolver.resolveById(formId);
        this._formDAO.checkHandleFormRight((AmetysObject)form);
        List<Page> pages = this._getFormPages(formId, siteName);
        if (pages.isEmpty()) {
            throw new AccessDeniedException("Can't send invitations for form id '" + formId + "' because it is not published.");
        }
        this._formMailHelper.sendInvitationMails(form, this._getUsersToInvite(form), message, language);
        return new HashMap<String, Object>();
    }

    private List<Page> _getFormPages(String formId, String siteName) {
        List<Page> pages = this._formDAO.getFormPage(formId, siteName).stream().filter(Page.class::isInstance).map(Page.class::cast).toList();
        return pages;
    }

    protected List<User> _getUsersToInvite(Form form) {
        if (this._rightManager.hasAnonymousReadAccess((Object)form)) {
            return List.of();
        }
        return this._rightManager.getReadAccessAllowedUsers((Object)form).resolveAllowedUsers(true).stream().filter(id -> !this._limitedEntriesHelper.hasUserAlreadyAnswer(form, (UserIdentity)id, null)).map(id -> this._userManager.getUser(id)).filter(Objects::nonNull).filter(u -> StringUtils.isNotEmpty((CharSequence)u.getEmail())).toList();
    }

    @Callable(rights={""})
    public int getNbOfUsersToInvite(String formId) {
        Form form = (Form)this._resolver.resolveById(formId);
        this._formDAO.checkHandleFormRight((AmetysObject)form);
        return this._getUsersToInvite(form).size();
    }
}

