/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.statistics;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Repository;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import org.ametys.plugins.forms.content.table.FormTableManager;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.runtime.plugin.component.PluginAware;
import org.ametys.runtime.plugins.admin.statistics.Statistics;
import org.ametys.runtime.plugins.admin.statistics.StatisticsNode;
import org.ametys.runtime.plugins.admin.statistics.StatisticsProvider;
import org.ametys.runtime.plugins.admin.statistics.StatisticsValue;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.slf4j.Logger;

public class ContentFormsStatisticsProvider
extends AbstractLogEnabled
implements StatisticsProvider,
Serviceable,
PluginAware {
    private String _id;
    private FormTableManager _formTableManager;
    private Repository _repository;

    public void service(ServiceManager manager) throws ServiceException {
        this._repository = (Repository)manager.lookup("javax.jcr.Repository");
        this._formTableManager = (FormTableManager)((Object)manager.lookup(FormTableManager.ROLE));
    }

    public void setPluginInfo(String pluginName, String featureName, String id) {
        this._id = id;
    }

    public Statistics getStatistics() {
        List<Integer> formsSubmissions = this._getFormsSubmissions();
        int submissions = formsSubmissions.stream().flatMapToInt(IntStream::of).sum();
        return new StatisticsNode(this._id, new I18nizableText("plugin.forms", "PLUGINS_FORMS_STATISTICS_CONTENTFORMS_LABEL"), "ametysicon-code-html-form", (Object)formsSubmissions.size(), List.of(new StatisticsNode("submissions", new I18nizableText("plugin.forms", "PLUGINS_FORMS_STATISTICS_CONTENTFORMS_SUBMISSIONS_LABEL"), "ametysicon-desktop-school-tool", (Object)submissions, List.of(new StatisticsValue("max", new I18nizableText("plugin.forms", "PLUGINS_FORMS_STATISTICS_CONTENTFORMS_SUBMISSIONS_MAX_LABEL"), "ametysicon-sort51", (Object)(formsSubmissions.size() > 0 ? formsSubmissions.get(formsSubmissions.size() - 1) : 0)), new StatisticsValue("median", new I18nizableText("plugin.forms", "PLUGINS_FORMS_STATISTICS_CONTENTFORMS_SUBMISSIONS_MEDIAN_LABEL"), "ametysicon-maths-window-symbol-x", (Object)(formsSubmissions.size() > 0 ? formsSubmissions.get(formsSubmissions.size() / 2) : 0))), false)), true);
    }

    private List<String> _getFormsIds() {
        Session session = null;
        try {
            session = this._repository.login();
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            Query query = queryManager.createQuery("//element(ametys-internal:forms, nt:unstructured)/*", "xpath");
            NodeIterator nodeIterator = query.execute().getNodes();
            ArrayList<String> formsIds = new ArrayList<String>();
            while (nodeIterator.hasNext()) {
                Node node = nodeIterator.nextNode();
                formsIds.add(node.getName());
            }
            ArrayList<String> arrayList = formsIds;
            return arrayList;
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot get forms", e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    private List<Integer> _getFormsSubmissions() {
        Logger logger = this.getLogger();
        try {
            return this._getFormsIds().stream().map(id -> {
                try {
                    return this._formTableManager.getTotalSubmissions((String)id);
                }
                catch (Exception e) {
                    logger.warn("An error occurred while retrieving the total submissions for the form " + id + ". It will be ignored.", (Throwable)e);
                    return 0;
                }
            }).sorted().toList();
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot compute content forms statistics", e);
        }
    }
}

