/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
 
 /**
 * This class controls the ribbon button to delete forms directories
 * @private
 */
Ext.define('Ametys.plugins.forms.controllers.DeleteFormDirectoryController', {
    extend: 'Ametys.ribbon.element.ui.ButtonController',

    constructor: function (config)
    {
        this.callParent(arguments);
        
        Ametys.message.MessageBus.on(Ametys.message.Message.MODIFIED, this._onFormModified, this);
    },
    
    /**
     * Listener on modified message.
     * Update the state of the controller accordingly.
     * @param {Ametys.message.Message} message the message of type modified.
     * @private
     */
    _onFormModified: function(message)
    {
        this.updateTargetsInCurrentSelectionTargets (message);
    },

    updateState: function()
    {
        this.disable();
        
        var targets = this.getMatchingTargets();
        
        if (targets.length > 0)
        {
            var ids = targets
                .map(function(target) { return target.getParameters().id; });
            Ametys.plugins.forms.dao.FormDirectoryDAO.canDeleteFormDirectories([ids], this._canDeleteCb, {scope: this, refreshing: true});
        }
    },
    
    /**
     * @private
     * Enables or disables the controller depending on the server response (can the form directory be removed ?)
     * @param {Object} response The server response
     */
    _canDeleteCb: function(response)
    {
        var canDeleteAll = !Ext.Array.contains(Ext.Object.getValues(response), false);
        if (canDeleteAll === true)
        {
            this.enable();
        }
        else
        {
            this.disable();
            this.setAdditionalDescription( this.getInitialConfig("no-right-description") );
        }
    }
});