/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.frontedition;

import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.StepDescriptor;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import com.opensymphony.workflow.spi.Step;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.jcr.RepositoryException;
import org.ametys.cms.clientsideelement.styles.HTMLEditorStyle;
import org.ametys.cms.content.RootContentHelper;
import org.ametys.cms.contenttype.AttributeDefinition;
import org.ametys.cms.contenttype.ContentType;
import org.ametys.cms.contenttype.ContentTypeExtensionPoint;
import org.ametys.cms.contenttype.ContentTypesHelper;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.WorkflowAwareContent;
import org.ametys.cms.workflow.ContentWorkflowHelper;
import org.ametys.core.right.RightManager;
import org.ametys.core.ui.ClientSideElement;
import org.ametys.core.ui.widgets.richtext.RichTextConfiguration;
import org.ametys.core.ui.widgets.richtext.RichTextConfigurationExtensionPoint;
import org.ametys.core.util.AmetysXSLTHelper;
import org.ametys.core.util.JSONUtils;
import org.ametys.plugins.core.ui.minimize.HashCache;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.repository.jcr.DefaultTraversableAmetysObject;
import org.ametys.plugins.repository.provider.RequestAttributeWorkspaceSelector;
import org.ametys.plugins.repository.version.VersionableAmetysObject;
import org.ametys.plugins.workflow.repository.WorkflowAwareAmetysObject;
import org.ametys.plugins.workflow.support.WorkflowHelper;
import org.ametys.plugins.workflow.support.WorkflowProvider;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.ModelItemGroup;
import org.ametys.runtime.plugin.PluginsManager;
import org.ametys.web.cache.PageHelper;
import org.ametys.web.renderingcontext.RenderingContext;
import org.ametys.web.repository.page.ModifiablePage;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.SitemapElement;
import org.ametys.web.repository.page.Zone;
import org.ametys.web.repository.page.ZoneItem;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.site.SiteManager;
import org.ametys.web.repository.sitemap.Sitemap;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.w3c.dom.NodeList;

public class AmetysFrontEditionHelper
implements Serviceable,
Contextualizable,
LogEnabled {
    public static final String FRONT_EDITION_RIGHT_ID = "Front_Edition_Access_Right";
    private static AmetysObjectResolver _ametysObjectResolver;
    private static HashCache _hashCache;
    private static RichTextConfigurationExtensionPoint _richTextConfigurationExtensionPoint;
    private static HTMLEditorStyle _htmlEditorStyle;
    private static RightManager _rightManager;
    private static ContentWorkflowHelper _contentWorkflowHelper;
    private static PageHelper _pageHelper;
    private static WorkflowHelper _workflowHelper;
    private static JSONUtils _jsonUtils;
    private static SiteManager _siteManager;
    private static WorkflowProvider _workflowProvider;
    private static ContentTypesHelper _contentTypesHelper;
    private static ContentTypeExtensionPoint _contentTypesEP;
    private static RootContentHelper _rootContentHelper;
    private static Context _context;
    private static Logger _logger;

    public void service(ServiceManager manager) throws ServiceException {
        _ametysObjectResolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        _siteManager = (SiteManager)manager.lookup(SiteManager.ROLE);
        _hashCache = (HashCache)manager.lookup(HashCache.ROLE);
        _richTextConfigurationExtensionPoint = (RichTextConfigurationExtensionPoint)manager.lookup(RichTextConfigurationExtensionPoint.ROLE);
        _htmlEditorStyle = (HTMLEditorStyle)manager.lookup(HTMLEditorStyle.ROLE);
        _rightManager = (RightManager)manager.lookup(RightManager.ROLE);
        _contentWorkflowHelper = (ContentWorkflowHelper)manager.lookup(ContentWorkflowHelper.ROLE);
        _contentTypesHelper = (ContentTypesHelper)manager.lookup(ContentTypesHelper.ROLE);
        _contentTypesEP = (ContentTypeExtensionPoint)manager.lookup(ContentTypeExtensionPoint.ROLE);
        _pageHelper = (PageHelper)manager.lookup(PageHelper.ROLE);
        _workflowHelper = (WorkflowHelper)manager.lookup(WorkflowHelper.ROLE);
        _jsonUtils = (JSONUtils)manager.lookup(JSONUtils.ROLE);
        _workflowProvider = (WorkflowProvider)manager.lookup(WorkflowProvider.ROLE);
        _rootContentHelper = (RootContentHelper)manager.lookup(RootContentHelper.ROLE);
    }

    public void contextualize(Context context) throws ContextException {
        _context = context;
    }

    public void enableLogging(Logger logger) {
        _logger = logger;
    }

    public static String prepareJSFiles(String locale, String theme) {
        String themeName = StringUtils.substringAfterLast((String)theme, (String)"/");
        HashMap<String, String> filesInfos = new HashMap<String, String>();
        filesInfos.put("media", "");
        filesInfos.put("tag", "script");
        LinkedHashMap<String, Map<String, String>> files = new LinkedHashMap<String, Map<String, String>>();
        files.put("/plugins/extjs7/resources/ext-all.js", filesInfos);
        files.put("/plugins/extjs7/resources/classic/locale/locale-" + locale + ".js", filesInfos);
        files.put(theme + "/" + themeName + ".js", filesInfos);
        files.put("/plugins/core-ui/resources/js/Ext.fixes." + locale + ".js", filesInfos);
        files.put("/plugins/core-ui/resources/js/Ext.enhancements." + locale + ".js", filesInfos);
        files.put("/plugins/core-ui/resources/js/Ametys." + locale + ".js", filesInfos);
        files.put("/plugins/front-edition/resources/js/Ametys/override/Ametys." + locale + ".js", filesInfos);
        files.put("/plugins/core-ui/resources/js/Ametys/mask/GlobalLoadMask." + locale + ".js", filesInfos);
        files.put("/plugins/core-ui/resources/js/Ametys/log/Logger." + locale + ".js", filesInfos);
        files.put("/plugins/core-ui/resources/js/Ametys/log/Logger/Entry." + locale + ".js", filesInfos);
        files.put("/plugins/core-ui/resources/js/Ametys/log/LoggerFactory." + locale + ".js", filesInfos);
        files.put("/plugins/core-ui/resources/js/Ametys/log/ErrorDialog." + locale + ".js", filesInfos);
        files.put("/plugins/core-ui/resources/js/Ametys/window/DialogBox." + locale + ".js", filesInfos);
        files.put("/plugins/front-edition/resources/js/Ametys/override/Ametys/window/DialogBox." + locale + ".js", filesInfos);
        files.put("/plugins/core-ui/resources/js/Ametys/window/MessageBox." + locale + ".js", filesInfos);
        files.put("/plugins/core-ui/resources/js/Ametys/form/AbstractField." + locale + ".js", filesInfos);
        files.put("/plugins/core-ui/resources/js/Ametys/form/AbstractFieldsWrapper." + locale + ".js", filesInfos);
        files.put("/plugins/core-ui/resources/js/Ametys/form/AbstractQueryableComboBox." + locale + ".js", filesInfos);
        files.put("/plugins/core-ui/resources/js/Ametys/form/AbstractQueryableComboBox/SplitterTracker." + locale + ".js", filesInfos);
        files.put("/plugins/front-edition/resources/js/Ametys/override/Ametys/form/widget/AbstractQueryableComboBox." + locale + ".js", filesInfos);
        files.put("/plugins/core-ui/resources/js/Ametys/form/field/DateTime." + locale + ".js", filesInfos);
        files.put("/plugins/core-ui/resources/js/Ametys/form/field/StringTime." + locale + ".js", filesInfos);
        files.put("/plugins/core-ui/resources/js/Ametys/form/field/Password." + locale + ".js", filesInfos);
        files.put("/plugins/core-ui/resources/js/Ametys/form/field/ChangePassword." + locale + ".js", filesInfos);
        files.put("/plugins/core-ui/resources/js/Ametys/form/field/ReferencedNumberField." + locale + ".js", filesInfos);
        files.put("/plugins/core-ui/resources/js/Ametys/form/field/RichText." + locale + ".js", filesInfos);
        files.put("/plugins/cms/resources/js/Ametys/cms/form/field/RichText." + locale + ".js", filesInfos);
        files.put("/plugins/core-ui/resources/js/Ametys/form/field/RichText/SplitterTracker." + locale + ".js", filesInfos);
        files.put("/plugins/core-ui/resources/js/Ametys/form/field/TextArea." + locale + ".js", filesInfos);
        files.put("/plugins/core-ui/resources/js/Ametys/form/field/ColorSelector." + locale + ".js", filesInfos);
        files.put("/plugins/core-ui/resources/js/Ametys/form/field/SelectUserDirectory." + locale + ".js", filesInfos);
        files.put("/plugins/core-ui/resources/js/Ametys/form/field/SelectGroupDirectories." + locale + ".js", filesInfos);
        files.put("/plugins/core-ui/resources/js/Ametys/form/field/Code." + locale + ".js", filesInfos);
        files.put("/plugins/core-ui/resources/js/Ametys/helper/ChooseLocationLeaflet." + locale + ".js", filesInfos);
        files.put("/plugins/core-ui/resources/js/Ametys/form/widget/GeoCode." + locale + ".js", filesInfos);
        files.put("/plugins/core-ui/resources/js/Ametys/grid/GridColumnHelper." + locale + ".js", filesInfos);
        files.put("/plugins/tiny_mce/resources/js/tinymce.js", filesInfos);
        files.put("/plugins/codemirror/resources/js/codemirror.js", filesInfos);
        files.put("/plugins/codemirror/resources/js/addon/edit/matchbrackets.js", filesInfos);
        files.put("/plugins/codemirror/resources/js/addon/selection/active-line.js", filesInfos);
        files.put("/plugins/codemirror/resources/js/mode/xml/xml.js", filesInfos);
        files.put("/plugins/codemirror/resources/js/mode/javascript/javascript.js", filesInfos);
        files.put("/plugins/codemirror/resources/js/mode/css/css.js", filesInfos);
        files.put("/plugins/codemirror/resources/js/mode/htmlmixed/htmlmixed.js", filesInfos);
        files.put("/plugins/core-ui/resources/js/Ametys/data/ServerCaller." + locale + ".js", filesInfos);
        files.put("/plugins/core-ui/resources/js/Ametys/data/ServerComm." + locale + ".js", filesInfos);
        files.put("/plugins/front-edition/resources/js/Ametys/override/Ametys/data/ServerComm." + locale + ".js", filesInfos);
        files.put("/plugins/core-ui/resources/js/Ametys/data/ServerCommProxy." + locale + ".js", filesInfos);
        files.put("/plugins/core-ui/resources/js/Ametys/data/ServerComm/TimeoutDialog." + locale + ".js", filesInfos);
        files.put("/plugins/core-ui/resources/js/Ametys/form/widget/RichText/RichTextConfigurationBase." + locale + ".js", filesInfos);
        files.put("/plugins/core-ui/resources/js/Ametys/form/widget/RichText/RichTextConfiguration." + locale + ".js", filesInfos);
        files.put("/plugins/core-ui/resources/js/Ametys/plugins/coreui/system/devmode/StacktraceHelper." + locale + ".js", filesInfos);
        files.put("/plugins/front-edition/resources/js/front-comm." + locale + ".js", filesInfos);
        files.put("/plugins/front-edition/resources/js/front-widget." + locale + ".js", filesInfos);
        files.put("/plugins/core-ui/resources/js/Ametys/helper/EnterURL." + locale + ".js", filesInfos);
        files.put("/plugins/core-ui/resources/js/Ametys/helper/FileUpload." + locale + ".js", filesInfos);
        files.put("/plugins/web/resources/js/Ametys/web/helper/ChoosePage." + locale + ".js", filesInfos);
        files.put("/plugins/web/resources/js/Ametys/web/helper/ContextToolbar." + locale + ".js", filesInfos);
        files.put("/plugins/web/resources/js/Ametys/web/sitemap/SitemapTree." + locale + ".js", filesInfos);
        files.put("/plugins/web/resources/js/Ametys/web/sitemap/SitemapTree/Page." + locale + ".js", filesInfos);
        files.put("/plugins/web/resources/js/Ametys/web/sitemap/SitemapTree/Sitemap." + locale + ".js", filesInfos);
        files.put("/plugins/web/resources/js/Ametys/web/site/SitesTree/Site." + locale + ".js", filesInfos);
        files.put("/plugins/cms/resources/js/Ametys/cms/editor/LinkHandler." + locale + ".js", filesInfos);
        files.put("/plugins/cms/resources/js/Ametys/plugins/cms/editor/Links." + locale + ".js", filesInfos);
        files.put("/plugins/cms/resources/js/Ametys/plugins/cms/editor/Links/LinkHandler." + locale + ".js", filesInfos);
        files.put("/plugins/web/resources/js/Ametys/plugins/web/editor/Links." + locale + ".js", filesInfos);
        files.put("/plugins/web/resources/js/Ametys/plugins/web/editor/PageLinkHandler." + locale + ".js", filesInfos);
        files.put("/plugins/cms/resources/js/Ametys/plugins/cms/editor/Images." + locale + ".js", filesInfos);
        files.put("/plugins/cms/resources/js/tinymce/basicstyles." + locale + ".js", filesInfos);
        files.put("/plugins/cms/resources/js/tinymce/lists." + locale + ".js", filesInfos);
        files.put("/plugins/cms/resources/js/tinymce/links." + locale + ".js", filesInfos);
        files.put("/plugins/web/resources/js/tinymce/links." + locale + ".js", filesInfos);
        files.put("/plugins/front-edition/resources/js/tinymce/links." + locale + ".js", filesInfos);
        files.put("/plugins/cms/resources/js/tinymce/styles." + locale + ".js", filesInfos);
        files.put("/plugins/cms/resources/js/tinymce/images." + locale + ".js", filesInfos);
        files.put("/plugins/front-edition/resources/js/tinymce/images." + locale + ".js", filesInfos);
        if (PluginsManager.getInstance().getPluginNames().contains("inlinemedia")) {
            files.put("/plugins/inlinemedia/resources/js/Ametys/plugins/inlinemedia/Media." + locale + ".js", filesInfos);
            files.put("/plugins/inlinemedia/resources/js/Ametys/plugins/inlinemedia/InsertMediaHelper." + locale + ".js", filesInfos);
            files.put("/plugins/inlinemedia/resources/js/tinymce/images." + locale + ".js", filesInfos);
        }
        files.put("/plugins/front-edition/resources/js/tinymce/save." + locale + ".js", filesInfos);
        files.put("/plugins/cms/resources/js/tinymce/tables." + locale + ".js", filesInfos);
        files.put("/plugins/front-edition/resources/js/tinymce/tables." + locale + ".js", filesInfos);
        files.put("/plugins/cms/resources/js/Ametys/plugins/cms/editor/Tables." + locale + ".js", filesInfos);
        files.put("/plugins/cms/resources/js/Ametys/plugins/cms/editor/BasicActions." + locale + ".js", filesInfos);
        files.put("/plugins/cms/resources/js/Ametys/cms/uihelper/ChooseResource." + locale + ".js", filesInfos);
        files.put("/plugins/explorer/resources/js/Ametys/explorer/tree/ExplorerTree." + locale + ".js", filesInfos);
        files.put("/plugins/explorer/resources/js/Ametys/explorer/tree/ExplorerTree/NodeEntry." + locale + ".js", filesInfos);
        files.put("/plugins/explorer/resources/js/Ametys/explorer/Resource." + locale + ".js", filesInfos);
        files.put("/plugins/explorer/resources/js/Ametys/explorer/ExplorerNodeDAO." + locale + ".js", filesInfos);
        files.put("/plugins/explorer/resources/js/Ametys/explorer/ExplorerNode." + locale + ".js", filesInfos);
        files.put("/plugins/web/resources/js/Ametys/plugins/web/explorer/ExplorerNode." + locale + ".js", filesInfos);
        files.put("/plugins/cms/resources/js/Ametys/cms/attach/AttachmentsExplorerTree." + locale + ".js", filesInfos);
        files.put("/plugins/cms/resources/js/Ametys/cms/uihelper/ChooseAttachmentFile." + locale + ".js", filesInfos);
        files.put("/plugins/front-edition/resources/js/Ametys/override/Ametys/cms/uihelper/ChooseAttachmentFile." + locale + ".js", filesInfos);
        files.put("/plugins/explorer/resources/js/Ametys/explorer/resources/actions/FileActions." + locale + ".js", filesInfos);
        files.put("/plugins/explorer/resources/js/Ametys/explorer/resources/helper/ResourceUpload." + locale + ".js", filesInfos);
        files.put("/plugins/core-ui/resources/js/Ametys/file/AbstractFileExplorerTree/FileNode." + locale + ".js", filesInfos);
        files.put("/plugins/core-ui/resources/js/Ametys/file/AbstractFileExplorerTree." + locale + ".js", filesInfos);
        files.put("/plugins/core-ui/resources/js/Ametys/message/Message." + locale + ".js", filesInfos);
        files.put("/plugins/core-ui/resources/js/Ametys/message/MessageTarget." + locale + ".js", filesInfos);
        files.put("/plugins/core-ui/resources/js/Ametys/message/MessageTargetFactory." + locale + ".js", filesInfos);
        files.put("/plugins/core-ui/resources/js/Ametys/message/factory/DefaultMessageTargetFactory." + locale + ".js", filesInfos);
        files.put("/plugins/front-edition/resources/js/Ametys/message/MessageTargetHelper." + locale + ".js", filesInfos);
        files.put("/plugins/web/resources/js/Ametys/plugins/web/page/AddPageWizard." + locale + ".js", filesInfos);
        files.put("/plugins/front-edition/resources/js/Ametys/override/Ametys/plugins/web/page/AddPageWizard." + locale + ".js", filesInfos);
        files.put("/plugins/web/resources/js/Ametys/web/sitemap/SitemapDAO." + locale + ".js", filesInfos);
        files.put("/plugins/web/resources/js/Ametys/web/sitemap/Sitemap." + locale + ".js", filesInfos);
        files.put("/plugins/web/resources/js/Ametys/web/page/PageDAO." + locale + ".js", filesInfos);
        files.put("/plugins/front-edition/resources/js/Ametys/override/Ametys/web/page/PageDAO." + locale + ".js", filesInfos);
        files.put("/plugins/web/resources/js/Ametys/plugins/web/page/AddPageWizard/Card." + locale + ".js", filesInfos);
        files.put("/plugins/web/resources/js/Ametys/plugins/web/page/AddPageWizard/CreatePageCard." + locale + ".js", filesInfos);
        files.put("/plugins/web/resources/js/Ametys/plugins/web/page/AddPageWizard/PageContentCard." + locale + ".js", filesInfos);
        files.put("/plugins/web/resources/js/Ametys/plugins/web/page/AddPageWizard/ContentPropertiesCard." + locale + ".js", filesInfos);
        files.put("/plugins/core-ui/resources/js/Ametys/form/Widget." + locale + ".js", filesInfos);
        files.put("/plugins/core-ui/resources/js/Ametys/form/ConfigurableFormPanel." + locale + ".js", filesInfos);
        files.put("/plugins/front-edition/resources/js/Ametys/userprefs/UserPrefsDAO." + locale + ".js", filesInfos);
        files.put("/plugins/core-ui/resources/js/Ametys/form/ConfigurableFormPanel/Repeater." + locale + ".js", filesInfos);
        files.put("/plugins/core-ui/resources/js/Ametys/form/ConfigurableFormPanel/FieldCheckersManager." + locale + ".js", filesInfos);
        files.put("/plugins/front-edition/resources/js/Ametys/message/MessageBus." + locale + ".js", filesInfos);
        files.put("/plugins/core-ui/resources/js/Ametys/form/WidgetManager." + locale + ".js", filesInfos);
        files.put("/plugins/core-ui/resources/js/Ametys/form/widget/DefaultWidgets." + locale + ".js", filesInfos);
        files.put("/plugins/core-ui/resources/js/Ametys/form/widget/Date." + locale + ".js", filesInfos);
        files.put("/plugins/core-ui/resources/js/Ametys/form/widget/DateTime." + locale + ".js", filesInfos);
        files.put("/plugins/front-edition/resources/js/Ametys/override/Ametys/form/WidgetManager." + locale + ".js", filesInfos);
        files.put("/plugins/cms/resources/js/Ametys/cms/content/ContentDAO." + locale + ".js", filesInfos);
        files.put("/plugins/web/resources/js/Ametys/web/content/ContentDAO." + locale + ".js", filesInfos);
        files.put("/plugins/front-edition/resources/js/Ametys/override/Ametys/cms/content/ContentDAO." + locale + ".js", filesInfos);
        files.put("/plugins/cms/resources/js/Ametys/cms/content/Content." + locale + ".js", filesInfos);
        files.put("/plugins/core-ui/resources/js/Ametys/navhistory/HistoryDAO." + locale + ".js", filesInfos);
        files.put("/plugins/core-ui/resources/js/Ametys/window/MessageBox." + locale + ".js", filesInfos);
        files.put("/plugins/front-edition/resources/js/Ametys/tool/ToolsManager." + locale + ".js", filesInfos);
        files.put("/plugins/cms/resources/js/Ametys/cms/form/widget/RichText." + locale + ".js", filesInfos);
        files.put("/plugins/front-edition/resources/js/Ametys/override/Ametys/cms/form/widget/SelectContent/ContentEntry." + locale + ".js", filesInfos);
        files.put("/plugins/cms/resources/js/Ametys/cms/form/widget/SelectContent." + locale + ".js", filesInfos);
        files.put("/plugins/front-edition/resources/js/Ametys/override/Ametys/cms/form/widget/SelectContent." + locale + ".js", filesInfos);
        files.put("/plugins/cms/resources/js/Ametys/cms/form/widget/SelectReferenceTableContent." + locale + ".js", filesInfos);
        files.put("/plugins/front-edition/resources/js/Ametys/override/Ametys/cms/form/widget/SelectReferenceTableContent." + locale + ".js", filesInfos);
        files.put("/plugins/web/resources/js/Ametys/plugins/web/page/AddPageWizard/PageTypeCard." + locale + ".js", filesInfos);
        files.put("/plugins/front-edition/resources/js/Ametys/override/Ametys/plugins/web/page/AddPageWizard/PageTypeCard." + locale + ".js", filesInfos);
        files.put("/plugins/web/resources/js/Ametys/web/form/widget/SelectPage." + locale + ".js", filesInfos);
        files.put("/plugins/front-edition/resources/js/Ametys/override/Ametys/web/form/widget/SelectPage." + locale + ".js", filesInfos);
        files.put("/plugins/web/resources/js/Ametys/web/form/widget/SelectSite." + locale + ".js", filesInfos);
        files.put("/plugins/web/resources/js/Ametys/web/helper/ChooseSite." + locale + ".js", filesInfos);
        files.put("/plugins/web/resources/js/Ametys/web/site/SitesTree." + locale + ".js", filesInfos);
        files.put("/plugins/web/resources/js/Ametys/web/site/SitesTree/Site." + locale + ".js", filesInfos);
        files.put("/plugins/web/resources/js/Ametys/web/helper/ContextToolbar." + locale + ".js", filesInfos);
        files.put("/plugins/web/resources/js/Ametys/web/site/SitesTree/Site." + locale + ".js", filesInfos);
        files.put("/plugins/web/resources/js/Ametys/web/form/widget/SelectPage/PageEntry." + locale + ".js", filesInfos);
        files.put("/plugins/web/resources/js/Ametys/plugins/web/page/AddPageWizard/TagsCard." + locale + ".js", filesInfos);
        files.put("/plugins/web/resources/js/Ametys/plugins/web/page/AddPageWizard/TagsCardLite." + locale + ".js", filesInfos);
        files.put("/plugins/web/resources/js/Ametys/web/page/Page." + locale + ".js", filesInfos);
        files.put("/plugins/cms/resources/js/Ametys/plugins/cms/tag/TagsTreePanel." + locale + ".js", filesInfos);
        files.put("/plugins/cms/resources/js/Ametys/plugins/cms/tag/TagsTreePanel/TagNode." + locale + ".js", filesInfos);
        files.put("/plugins/web/resources/js/Ametys/plugins/web/sitemap/SitemapActions." + locale + ".js", filesInfos);
        files.put("/plugins/web/resources/js/Ametys/plugins/web/tag/AffectTagAction." + locale + ".js", filesInfos);
        files.put("/plugins/cms/resources/js/Ametys/cms/uihelper/ChooseTagHelper." + locale + ".js", filesInfos);
        files.put("/plugins/cms/resources/js/Ametys/cms/uihelper/ChooseTag." + locale + ".js", filesInfos);
        files.put("/plugins/web/resources/js/Ametys/web/helper/ChooseTag." + locale + ".js", filesInfos);
        files.put("/plugins/cms/resources/js/Ametys/plugins/cms/tag/TagActions." + locale + ".js", filesInfos);
        files.put("/plugins/web/resources/js/Ametys/plugins/web/tag/TagsTreePanel." + locale + ".js", filesInfos);
        files.put("/plugins/web/resources/js/Ametys/plugins/web/page/SchedulePublication." + locale + ".js", filesInfos);
        files.put("/plugins/front-edition/resources/js/Ametys/override/Ametys/plugins/web/page/SchedulePublication." + locale + ".js", filesInfos);
        files.put("/plugins/core-ui/resources/js/Ametys/plugins/coreui/system/StartTimeChecker." + locale + ".js", filesInfos);
        files.put("/plugins/cms/resources/js/Ametys/cms/uihelper/EditContent." + locale + ".js", filesInfos);
        files.put("/plugins/web/resources/js/Ametys/plugins/web/zone/ZoneActions." + locale + ".js", filesInfos);
        files.put("/plugins/web/resources/js/Ametys/plugins/web/zone/ZoneDAO." + locale + ".js", filesInfos);
        files.put("/plugins/core-ui/resources/js/Ametys/form/widget/File." + locale + ".js", filesInfos);
        files.put("/plugins/front-edition/resources/js/Ametys/override/Ametys/form/widget/File." + locale + ".js", filesInfos);
        files.put("/plugins/core-ui/resources/js/Ametys/form/widget/File/FileSource." + locale + ".js", filesInfos);
        files.put("/plugins/core-ui/resources/js/Ametys/form/widget/File/External." + locale + ".js", filesInfos);
        files.put("/plugins/cms/resources/js/Ametys/cms/form/widget/File/Resource." + locale + ".js", filesInfos);
        files.put("/plugins/core-ui/resources/js/Ametys/helper/crop/CropDialog." + locale + ".js", filesInfos);
        files.put("/plugins/core-ui/resources/js/Jcrop/jquery.Jcrop." + locale + ".js", filesInfos);
        files.put("/plugins/core-ui/resources/js/Ametys/form/widget/Image." + locale + ".js", filesInfos);
        files.put("/plugins/front-edition/resources/js/Ametys/override/Ametys/form/widget/Image." + locale + ".js", filesInfos);
        files.put("/plugins/core-ui/resources/js/Ametys/form/SaveHelper." + locale + ".js", filesInfos);
        files.put("/plugins/core-ui/resources/js/Ametys/form/SaveHelper/SaveErrorDialog." + locale + ".js", filesInfos);
        files.put("/plugins/cms/resources/js/Ametys/cms/content/ContentErrorHelper." + locale + ".js", filesInfos);
        AmetysFrontEditionHelper._addRichTextConfigurationFiles(files, filesInfos, locale, true);
        return _hashCache.createHash(files, locale);
    }

    public static String prepareCSSFiles(String locale, String theme) {
        HashMap<String, String> filesInfos = new HashMap<String, String>();
        filesInfos.put("media", "");
        filesInfos.put("tag", "link");
        LinkedHashMap<String, Map<String, String>> files = new LinkedHashMap<String, Map<String, String>>();
        String themeName = StringUtils.substringAfterLast((String)theme, (String)"/");
        files.put(theme + "/" + themeName + "-all.css", filesInfos);
        files.put("/plugins/front-edition/resources/css/theme-ametys-base-light.css", filesInfos);
        files.put("/plugins/core-ui/resources/font/ametys/AmetysIcon.css", filesInfos);
        files.put("/plugins/core-ui/resources/css/Ametys/form/image.css", filesInfos);
        files.put("/plugins/core-ui/resources/css/Jcrop/jquery.Jcrop.css", filesInfos);
        files.put("/plugins/web/resources/css/pages/addpage.css", filesInfos);
        files.put("/plugins/cms/resources/css/selectcontent.css", filesInfos);
        files.put("/plugins/codemirror/resources/css/codemirror.css", filesInfos);
        files.put("/plugins/codemirror/resources/js/addon/hint/show-hint.css", filesInfos);
        AmetysFrontEditionHelper._addRichTextConfigurationFiles(files, filesInfos, locale, false);
        return _hashCache.createHash(files, locale);
    }

    private static List<ClientSideElement.ScriptFile> _getRichTextConfigurationFiles(boolean scripts, Map<String, Object> contextParameters) {
        ArrayList<ClientSideElement.ScriptFile> files = new ArrayList<ClientSideElement.ScriptFile>();
        for (String richTextConfigurationId : _richTextConfigurationExtensionPoint.getExtensionsIds()) {
            RichTextConfiguration richTextConfiguration = (RichTextConfiguration)_richTextConfigurationExtensionPoint.getExtension(richTextConfigurationId);
            for (String category : richTextConfiguration.getCategories()) {
                List backOfficeCSSFiles;
                Set convertors = richTextConfiguration.getConvertors(category, contextParameters);
                AmetysFrontEditionHelper._addFilesForClientSideElements(scripts, files, convertors);
                Set validators = richTextConfiguration.getValidators(category, contextParameters);
                AmetysFrontEditionHelper._addFilesForClientSideElements(scripts, files, validators);
                if (scripts || (backOfficeCSSFiles = _htmlEditorStyle.getBackOfficeCSSFiles(category, contextParameters)) == null) continue;
                files.addAll(backOfficeCSSFiles);
            }
        }
        return files;
    }

    private static void _addFilesForClientSideElements(boolean scripts, List<ClientSideElement.ScriptFile> files, Set<ClientSideElement> clientSideElmts) {
        if (clientSideElmts != null) {
            for (ClientSideElement convertor : clientSideElmts) {
                List scriptsToAdd = convertor.getScripts(Collections.EMPTY_MAP);
                if (scriptsToAdd == null) continue;
                for (ClientSideElement.Script script : scriptsToAdd) {
                    List scriptFiles = scripts ? script.getScriptFiles() : script.getCSSFiles();
                    if (scriptFiles == null) continue;
                    files.addAll(scriptFiles);
                }
            }
        }
    }

    private static void _addRichTextConfigurationFiles(Map<String, Map<String, String>> files, Map<String, String> filesInfos, String locale, boolean scripts) {
        HashMap<String, Object> contextParameters = new HashMap<String, Object>();
        contextParameters.put("siteName", org.ametys.web.transformation.xslt.AmetysXSLTHelper.site());
        List<ClientSideElement.ScriptFile> richTextConfigurationFiles = AmetysFrontEditionHelper._getRichTextConfigurationFiles(scripts, contextParameters);
        for (ClientSideElement.ScriptFile file : richTextConfigurationFiles) {
            String uri = null;
            if (file.isLangSpecific()) {
                if (file.getLangPaths().containsKey(locale)) {
                    uri = (String)file.getLangPaths().get(locale);
                } else if (file.getLangPaths().containsKey(file.getDefaultLang())) {
                    uri = (String)file.getLangPaths().get(file.getDefaultLang());
                }
            } else {
                uri = file.getPath();
            }
            if (uri == null) continue;
            files.put(uri, filesInfos);
        }
    }

    @Deprecated
    public static boolean hasFrontEditionRight(String rightId, String objectId) {
        return AmetysFrontEditionHelper.hasFrontEditionRight(rightId, objectId, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasFrontEditionRight(String rightId, String objectId, boolean editionModeOnly) {
        String aoId = objectId;
        if (StringUtils.isEmpty((CharSequence)aoId)) {
            aoId = org.ametys.web.transformation.xslt.AmetysXSLTHelper.pageId();
        }
        if (StringUtils.isEmpty((CharSequence)aoId) || !RenderingContext.FRONT.toString().equals(org.ametys.web.transformation.xslt.AmetysXSLTHelper.renderingContext()) || editionModeOnly && !org.ametys.web.transformation.xslt.AmetysXSLTHelper.isEditionMode() || !AmetysFrontEditionHelper.hasFrontEditionRight()) {
            return false;
        }
        Request request = ContextHelper.getRequest((Context)_context);
        String currentWsp = RequestAttributeWorkspaceSelector.getForcedWorkspace((Request)request);
        try {
            RequestAttributeWorkspaceSelector.setForcedWorkspace((Request)request, (String)"default");
            if (StringUtils.contains((CharSequence)aoId, (CharSequence)";")) {
                String[] pageIds;
                for (String pid : pageIds = StringUtils.split((String)aoId, (String)";")) {
                    if (_rightManager.currentUserHasRight(rightId, (Object)_ametysObjectResolver.resolveById(pid)) != RightManager.RightResult.RIGHT_ALLOW) continue;
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            boolean bl = StringUtils.isEmpty((CharSequence)rightId) || _rightManager.currentUserHasRight(rightId, (Object)_ametysObjectResolver.resolveById(aoId)) == RightManager.RightResult.RIGHT_ALLOW;
            return bl;
        }
        finally {
            RequestAttributeWorkspaceSelector.setForcedWorkspace((Request)request, (String)currentWsp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasFrontEditionRight(String rightId, AmetysObject ao, boolean editionModeOnly) {
        if (!RenderingContext.FRONT.toString().equals(org.ametys.web.transformation.xslt.AmetysXSLTHelper.renderingContext()) || editionModeOnly && !org.ametys.web.transformation.xslt.AmetysXSLTHelper.isEditionMode() || !AmetysFrontEditionHelper.hasFrontEditionRight()) {
            return false;
        }
        Request request = ContextHelper.getRequest((Context)_context);
        String currentWsp = RequestAttributeWorkspaceSelector.getForcedWorkspace((Request)request);
        try {
            RequestAttributeWorkspaceSelector.setForcedWorkspace((Request)request, (String)"default");
            boolean bl = StringUtils.isEmpty((CharSequence)rightId) || _rightManager.currentUserHasRight(rightId, (Object)ao) == RightManager.RightResult.RIGHT_ALLOW;
            return bl;
        }
        finally {
            RequestAttributeWorkspaceSelector.setForcedWorkspace((Request)request, (String)currentWsp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasFrontEditionRight() {
        Request request = ContextHelper.getRequest((Context)_context);
        String currentWsp = RequestAttributeWorkspaceSelector.getForcedWorkspace((Request)request);
        try {
            String siteName;
            RequestAttributeWorkspaceSelector.setForcedWorkspace((Request)request, (String)"default");
            String pageId = org.ametys.web.transformation.xslt.AmetysXSLTHelper.pageId();
            if (StringUtils.isNotEmpty((CharSequence)pageId)) {
                Page page = (Page)_ametysObjectResolver.resolveById(pageId);
                boolean bl = _rightManager.currentUserHasRight(FRONT_EDITION_RIGHT_ID, (Object)page) == RightManager.RightResult.RIGHT_ALLOW;
                return bl;
            }
            String lang = org.ametys.web.transformation.xslt.AmetysXSLTHelper.lang();
            if (StringUtils.isEmpty((CharSequence)lang)) {
                lang = (String)request.getAttribute("lang");
            }
            if (StringUtils.isNotEmpty((CharSequence)(siteName = org.ametys.web.transformation.xslt.AmetysXSLTHelper.site())) && StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{lang})) {
                Site site = _siteManager.getSite(siteName);
                Sitemap sitemap = site.getSitemap(lang);
                boolean bl = _rightManager.currentUserHasRight(FRONT_EDITION_RIGHT_ID, (Object)sitemap) == RightManager.RightResult.RIGHT_ALLOW;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            RequestAttributeWorkspaceSelector.setForcedWorkspace((Request)request, (String)currentWsp);
        }
    }

    public static boolean hasWorkflowRight(int actionId, String contentId, boolean checkEditionMode) {
        ArrayList<Integer> actionIds = new ArrayList<Integer>();
        actionIds.add(actionId);
        return AmetysFrontEditionHelper.hasWorkflowRight(actionIds, contentId, checkEditionMode);
    }

    public static boolean hasWorkflowRight(List<Integer> actionIds, String contentId, boolean checkEditionMode) {
        Content content = (Content)_ametysObjectResolver.resolveById(contentId);
        return AmetysFrontEditionHelper.hasWorkflowRight(actionIds, content, checkEditionMode);
    }

    public static boolean hasWorkflowRight(List<Integer> actionIds, Content content, boolean checkEditionMode) {
        boolean editionModeOk;
        if (checkEditionMode && !(editionModeOk = org.ametys.web.transformation.xslt.AmetysXSLTHelper.isEditionMode())) {
            return false;
        }
        boolean result = false;
        if (content instanceof WorkflowAwareContent) {
            WorkflowAwareContent wcontent = (WorkflowAwareContent)content;
            int[] availableActions = _contentWorkflowHelper.getAvailableActions(wcontent);
            for (int actionId : actionIds) {
                if (!(result = result || ArrayUtils.contains((int[])availableActions, (int)actionId))) continue;
                break;
            }
        }
        return result;
    }

    public static String getPageToolbarConfig(String pageId, String addContentsConfigAsJson, boolean editionModeOnly) throws UnknownAmetysObjectException, AmetysRepositoryException, RepositoryException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Page page = (Page)_ametysObjectResolver.resolveById(pageId);
        SitemapElement parent = (SitemapElement)page.getParent();
        long position = AmetysFrontEditionHelper._getPagePosition(page);
        List addContentsConfig = _jsonUtils.convertJsonToList(addContentsConfigAsJson);
        Set allowedContentTypes = addContentsConfig.stream().filter(Map.class::isInstance).filter(cfg -> AmetysFrontEditionHelper._hasContentCreationRight((Map)cfg)).map(cfg -> (String)((Map)cfg).get("contentType")).collect(Collectors.toSet());
        result.put("allowedContentTypes", allowedContentTypes);
        result.put("title", page.getTitle());
        result.put("parentId", parent.getId());
        result.put("position", position);
        result.put("actionStatus", AmetysFrontEditionHelper._getActionStatusOnPage(page, position, parent.getChildrenPages().getSize(), editionModeOnly));
        return _jsonUtils.convertObjectToJson(result);
    }

    private static boolean _hasContentCreationRight(Map<String, Object> config) {
        if (config.containsKey("contentType")) {
            String cTypeId = (String)config.get("contentType");
            ContentType contentType = (ContentType)_contentTypesEP.getExtension(cTypeId);
            if (contentType == null) {
                _logger.warn("Unknown content type '" + cTypeId + "'");
                return false;
            }
            String right = contentType.getRight();
            if (StringUtils.isEmpty((CharSequence)right)) {
                return true;
            }
            return _rightManager.currentUserHasRight(right, (Object)"/cms") == RightManager.RightResult.RIGHT_ALLOW || _rightManager.currentUserHasRight(right, (Object)_rootContentHelper.getRootContent()) == RightManager.RightResult.RIGHT_ALLOW;
        }
        _logger.warn("Configuration to add content is invalid: missing 'contentType'. It will be ignored");
        return false;
    }

    private static long _getPagePosition(Page page) throws AmetysRepositoryException {
        SitemapElement parent = (SitemapElement)page.getParent();
        AmetysObjectIterable children = parent.getChildrenPages();
        long count = 1L;
        for (Page child : children) {
            if (child.getId().equals(page.getId())) {
                return count;
            }
            ++count;
        }
        return -1L;
    }

    private static Map<String, Boolean> _getActionStatusOnPage(Page page, long position, long size, boolean editionModeOnly) throws UnknownAmetysObjectException, AmetysRepositoryException {
        HashMap<String, Boolean> rights = new HashMap<String, Boolean>();
        if (page instanceof ModifiablePage) {
            rights.put("add-content", AmetysFrontEditionHelper.hasFrontEditionRight("Web_Rights_Page_AddContent", (AmetysObject)page, editionModeOnly));
            rights.put("add-page", AmetysFrontEditionHelper.hasFrontEditionRight("Web_Rights_Page_Create", (AmetysObject)page, editionModeOnly));
            rights.put("tag", AmetysFrontEditionHelper.hasFrontEditionRight("Web_Rights_Page_Tag", (AmetysObject)page, editionModeOnly));
            rights.put("rename", AmetysFrontEditionHelper.hasFrontEditionRight("Web_Rights_Page_Rename", (AmetysObject)page, editionModeOnly));
            rights.put("schedule-publication", AmetysFrontEditionHelper.hasFrontEditionRight("Web_Rights_Page_Schedule", (AmetysObject)page, editionModeOnly));
            rights.put("delete", AmetysFrontEditionHelper.hasFrontEditionRight("Web_Rights_Page_Delete", (AmetysObject)page, editionModeOnly));
            boolean canMove = AmetysFrontEditionHelper.hasFrontEditionRight("Web_Rights_Page_Create", page.getParent().getId(), editionModeOnly);
            boolean moveUp = canMove && position > 1L;
            boolean moveDown = canMove && position < size;
            rights.put("move-up", moveUp);
            rights.put("move-down", moveDown);
            rights.put("move", moveDown || moveUp);
        }
        return rights;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContentToolbarConfig(String contentId, String zoneItemId, String restrictedActions, String jsonStepConfig, String locale, boolean editionModeOnly) throws UnknownAmetysObjectException, AmetysRepositoryException, RepositoryException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Content content = (Content)_ametysObjectResolver.resolveById(contentId);
        result.put("actionStatus", AmetysFrontEditionHelper._getActionStatusOnContent(content, zoneItemId, editionModeOnly));
        if (content instanceof WorkflowAwareContent) {
            WorkflowDescriptor workflowDescriptor = AmetysFrontEditionHelper._getWorkflowDescriptor((WorkflowAwareContent)content);
            WorkflowAwareContent wcontent = (WorkflowAwareContent)content;
            HashMap<String, Long> step = new HashMap<String, Long>();
            long currentStepId = wcontent.getCurrentStepId();
            StepDescriptor stepDescriptor = AmetysFrontEditionHelper._getStepDescriptor(workflowDescriptor, currentStepId);
            step.put("id", currentStepId);
            String name = stepDescriptor.getName();
            step.put("label", (Long)new I18nizableText(StringUtils.substringBefore((String)name, (String)":"), StringUtils.substringAfter((String)name, (String)":")));
            result.put("step", step);
            Map stepConfig = StringUtils.isEmpty((CharSequence)jsonStepConfig) ? null : _jsonUtils.convertJsonToMap(jsonStepConfig);
            result.put("statusHistory", AmetysFrontEditionHelper._getStatusHistory(wcontent, currentStepId, stepConfig, workflowDescriptor));
            List availableActions = Arrays.stream(_contentWorkflowHelper.getAvailableActions(wcontent)).boxed().collect(Collectors.toList());
            result.put("availableWorkflowActions", availableActions);
            if (!editionModeOnly || org.ametys.web.transformation.xslt.AmetysXSLTHelper.isEditionMode()) {
                List restrictedActionsAsList = StringUtils.isEmpty((CharSequence)restrictedActions) ? null : _jsonUtils.convertJsonToList(restrictedActions);
                List restrictedActionIds = restrictedActionsAsList == null ? null : restrictedActionsAsList.stream().map(o -> o instanceof Map ? ((Map)o).get("id") : o).collect(Collectors.toList());
                Map<Object, Map> workflowActions = availableActions.stream().filter(actionId -> restrictedActionIds == null || restrictedActionIds.contains(actionId)).map(actionId -> {
                    HashMap<String, Object> wa = new HashMap<String, Object>();
                    AmetysFrontEditionHelper._addDefaultWorkflowActionProperties(wa, workflowDescriptor, actionId);
                    if (restrictedActionIds != null && restrictedActionsAsList != null && restrictedActionIds.contains(actionId)) {
                        for (Object object : restrictedActionsAsList) {
                            if (!(object instanceof Map) || ((Map)object).get("id") != actionId) continue;
                            wa.putAll((Map)object);
                            break;
                        }
                    }
                    return Pair.of((Object)actionId, wa);
                }).collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
                result.put("workflowActions", workflowActions);
            }
        }
        Request request = ContextHelper.getRequest((Context)_context);
        try {
            request.setAttribute("locale", (Object)locale);
            String string = _jsonUtils.convertObjectToJson(result);
            return string;
        }
        finally {
            request.removeAttribute("locale");
        }
    }

    private static Map<String, Boolean> _getActionStatusOnContent(Content content, String zoneItemId, boolean editionModeOnly) throws UnknownAmetysObjectException, AmetysRepositoryException {
        HashMap<String, Boolean> rights = new HashMap<String, Boolean>();
        ZoneItem zoneItem = (ZoneItem)_ametysObjectResolver.resolveById(zoneItemId);
        Zone zone = zoneItem.getZone();
        SitemapElement sitemapElement = zone.getSitemapElement();
        rights.put("tag", AmetysFrontEditionHelper.hasFrontEditionRight("CMS_Rights_Content_Tag", (AmetysObject)content, editionModeOnly));
        rights.put("remove", sitemapElement instanceof ModifiablePage && AmetysFrontEditionHelper.hasFrontEditionRight("Web_Rights_Page_DeleteZoneItem", (AmetysObject)sitemapElement, editionModeOnly));
        rights.put("delete", AmetysFrontEditionHelper.hasFrontEditionRight("CMS_Rights_DeleteContent", (AmetysObject)content, editionModeOnly));
        boolean moveUp = false;
        boolean moveDown = false;
        long position = AmetysFrontEditionHelper.getZoneItemPosition(zoneItem);
        long size = AmetysFrontEditionHelper.getZoneSize(zone);
        if (position != -1L && sitemapElement instanceof ModifiablePage && AmetysFrontEditionHelper.hasFrontEditionRight("Web_Rights_Page_OrganizeZoneItem", (AmetysObject)sitemapElement, editionModeOnly)) {
            if (position > 0L) {
                moveUp = true;
            }
            if (position + 1L < size) {
                moveDown = true;
            }
        }
        rights.put("move-up", moveUp);
        rights.put("move-down", moveDown);
        rights.put("move", moveDown || moveUp);
        return rights;
    }

    private static Map<Integer, Map<String, Object>> _getStatusHistory(WorkflowAwareContent content, long currentStepId, Map<String, Object> stepsConfig, WorkflowDescriptor workflowDescriptor) {
        ArrayList<Step> historyStatus = new ArrayList<Step>();
        if (stepsConfig.containsKey(String.valueOf(currentStepId))) {
            WorkflowProvider.AmetysObjectWorkflow workflow = _workflowProvider.getAmetysObjectWorkflow((WorkflowAwareAmetysObject)content);
            long workflowId = content.getWorkflowId();
            List historySteps = workflow.getHistorySteps(workflowId);
            Collections.sort(historySteps, new Comparator<Step>(){

                @Override
                public int compare(Step s1, Step s2) {
                    return -s1.getStartDate().compareTo(s2.getStartDate());
                }
            });
            Map currentStepCfg = (Map)stepsConfig.get(String.valueOf(currentStepId));
            String currentStepType = currentStepCfg != null ? (String)currentStepCfg.get("type") : null;
            boolean stop = false;
            for (Step step : historySteps) {
                if (stop) break;
                long stepId = step.getStepId();
                Map stepCfg = (Map)stepsConfig.get(String.valueOf(stepId));
                String stepType = stepCfg != null ? (String)stepCfg.get("type") : null;
                stop = "positive".equals(currentStepType) && !"positive".equals(stepType) || ("negative".equals(currentStepType) || "neutral".equals(currentStepType)) && !"negative".equals(stepType) || currentStepId == stepId;
                if (stop) continue;
                historyStatus.add(step);
            }
        }
        LinkedHashMap<Integer, Map<String, Object>> jsonHistoryStatus = new LinkedHashMap<Integer, Map<String, Object>>();
        for (Step step : historyStatus) {
            if (jsonHistoryStatus.containsKey(step.getStepId())) continue;
            StepDescriptor stepDescriptor = AmetysFrontEditionHelper._getStepDescriptor(workflowDescriptor, step.getStepId());
            String name = stepDescriptor.getName();
            I18nizableText label = new I18nizableText(StringUtils.substringBefore((String)name, (String)":"), StringUtils.substringAfter((String)name, (String)":"));
            jsonHistoryStatus.put(step.getStepId(), Map.of("label", label));
        }
        return jsonHistoryStatus;
    }

    private static void _addDefaultWorkflowActionProperties(Map<String, Object> wa, WorkflowDescriptor workflowDescriptor, int actionId) {
        ActionDescriptor wAction = workflowDescriptor.getAction(actionId);
        String name = wAction.getName();
        wa.put("label", new I18nizableText(StringUtils.substringBefore((String)name, (String)":"), StringUtils.substringAfter((String)name, (String)":")));
        switch (actionId) {
            case 3: {
                wa.put("icon", "fas fa-hand-point-up");
                break;
            }
            case 4: {
                wa.put("icon", "fas fa-check");
                break;
            }
            case 7: {
                wa.put("icon", "fas fa-times");
                break;
            }
            case 10: {
                wa.put("icon", "fas fa-ban");
                break;
            }
        }
    }

    private static WorkflowDescriptor _getWorkflowDescriptor(WorkflowAwareContent content) {
        long workflowId = content.getWorkflowId();
        WorkflowProvider.AmetysObjectWorkflow workflow = _workflowProvider.getAmetysObjectWorkflow((WorkflowAwareAmetysObject)content);
        String workflowName = workflow.getWorkflowName(workflowId);
        return workflow.getWorkflowDescriptor(workflowName);
    }

    private static StepDescriptor _getStepDescriptor(WorkflowDescriptor workflowDescriptor, long stepId) {
        StepDescriptor stepDescriptor;
        if (workflowDescriptor != null && (stepDescriptor = workflowDescriptor.getStep((int)stepId)) != null) {
            return stepDescriptor;
        }
        return null;
    }

    public static String getModifiableContents(int actionId, String inputPageId, boolean checkEditionMode) {
        AmetysObject resolveById;
        HashMap jsonObject = new HashMap();
        String pageId = inputPageId;
        if (StringUtils.isEmpty((CharSequence)inputPageId)) {
            pageId = org.ametys.web.transformation.xslt.AmetysXSLTHelper.pageId();
        }
        if (!StringUtils.isEmpty((CharSequence)pageId) && (resolveById = _ametysObjectResolver.resolveById(pageId)) instanceof Page) {
            Page page = (Page)resolveById;
            List contents = _pageHelper.getAllContents(page);
            for (Content content : contents) {
                HashMap<String, Object> contentInfo = new HashMap<String, Object>();
                contentInfo.put("unmodifiableAttributes", AmetysFrontEditionHelper.getUnmodifiableAttributes(content, List.of(Integer.valueOf(actionId)), checkEditionMode));
                contentInfo.put("rights", AmetysFrontEditionHelper.getRightsForContent(content));
                jsonObject.put(content.getId(), contentInfo);
            }
        }
        return _jsonUtils.convertObjectToJson(jsonObject);
    }

    public static List<String> getUnmodifiableAttributes(Content content, List<Integer> actionIds, boolean checkEditionMode) {
        try {
            boolean hasWorkflowRight = AmetysFrontEditionHelper.hasWorkflowRight(actionIds, content, checkEditionMode);
            if (!hasWorkflowRight) {
                return null;
            }
            Collection modelItems = _contentTypesHelper.getModelItems(content.getTypes());
            List<AttributeDefinition> attributes = AmetysFrontEditionHelper._getAttributeDefinitionsRecursively(modelItems);
            return attributes.stream().filter(mi -> !mi.canWrite(content)).map(mi -> mi.getPath()).collect(Collectors.toList());
        }
        catch (IllegalArgumentException e) {
            _logger.error("Fail to get restricted model items for content " + content.getId(), (Throwable)e);
            return List.of();
        }
    }

    public static Map<String, Object> getRightsForContent(Content content) {
        HashMap<String, Object> rights = new HashMap<String, Object>();
        rights.put("hasAddFileRight", _rightManager.currentUserHasRight("Plugin_Explorer_File_Add", (Object)content) == RightManager.RightResult.RIGHT_ALLOW);
        return rights;
    }

    private static List<AttributeDefinition> _getAttributeDefinitionsRecursively(Collection<? extends ModelItem> modelItems) {
        ArrayList<AttributeDefinition> attributeDefs = new ArrayList<AttributeDefinition>();
        for (ModelItem modelItem : modelItems) {
            if (modelItem instanceof AttributeDefinition) {
                attributeDefs.add((AttributeDefinition)modelItem);
                continue;
            }
            if (!(modelItem instanceof ModelItemGroup)) continue;
            attributeDefs.addAll(AmetysFrontEditionHelper._getAttributeDefinitionsRecursively(((ModelItemGroup)modelItem).getModelItems()));
        }
        return attributeDefs;
    }

    public static String getWorkflowName(String workflowName, int actionId) {
        String workflowNameKey = _workflowHelper.getActionName(workflowName, actionId);
        String translatedName = AmetysXSLTHelper.translate((String)workflowNameKey);
        return translatedName;
    }

    public static String getPageStatus(String pageId) {
        boolean hasDraft = false;
        boolean hasValidated = false;
        AmetysObject resolveById = _ametysObjectResolver.resolveById(pageId);
        if (resolveById instanceof Page) {
            Page page = (Page)resolveById;
            List contents = _pageHelper.getAllContents(page);
            for (Content content : contents) {
                if (AmetysFrontEditionHelper.isContentLive(content)) {
                    hasValidated = true;
                    continue;
                }
                hasDraft = true;
            }
            String result = "none";
            if (hasDraft && !hasValidated) {
                result = "draft";
            } else if (!hasDraft && hasValidated) {
                result = "validated";
            } else if (hasDraft && hasValidated) {
                result = "mixed";
            }
            return result;
        }
        return "";
    }

    public static long getContentWorkflowId(String contentId) {
        AmetysObject resolvedById = _ametysObjectResolver.resolveById(contentId);
        if (resolvedById instanceof Content) {
            Content content = (Content)resolvedById;
            return AmetysFrontEditionHelper.getContentWorkflowId(content);
        }
        return 0L;
    }

    public static long getContentWorkflowId(Content content) {
        WorkflowAwareContent wContent = (WorkflowAwareContent)content;
        return wContent.getCurrentStepId();
    }

    public static String getContentStatus(String contentId) {
        AmetysObject resolvedById = _ametysObjectResolver.resolveById(contentId);
        if (resolvedById instanceof Content) {
            Content content = (Content)resolvedById;
            return AmetysFrontEditionHelper.getContentStatus(content);
        }
        return "";
    }

    public static String getContentStatus(Content content) {
        return AmetysFrontEditionHelper.isContentLive(content) ? "validated" : "draft";
    }

    public static boolean isContentLive(String contentId) {
        AmetysObject resolvedById = _ametysObjectResolver.resolveById(contentId);
        if (resolvedById instanceof Content) {
            Content content = (Content)resolvedById;
            return AmetysFrontEditionHelper.isContentLive(content);
        }
        return false;
    }

    public static boolean isContentLive(Content content) {
        return Arrays.asList(((VersionableAmetysObject)content).getLabels()).contains("Live");
    }

    public static long getZoneItemPosition(String zoneItemId) throws UnknownAmetysObjectException, AmetysRepositoryException {
        ZoneItem zoneItem = (ZoneItem)_ametysObjectResolver.resolveById(zoneItemId);
        return AmetysFrontEditionHelper.getZoneItemPosition(zoneItem);
    }

    public static long getZoneItemPosition(ZoneItem zoneItem) {
        AmetysObject parent = zoneItem.getParent();
        if (parent instanceof DefaultTraversableAmetysObject) {
            return ((DefaultTraversableAmetysObject)parent).getChildPosition((AmetysObject)zoneItem);
        }
        return -1L;
    }

    public static long getZoneSize(String zoneName, String pageId) {
        Page page = (Page)_ametysObjectResolver.resolveById(pageId);
        Zone zone = page.getZone(zoneName);
        return AmetysFrontEditionHelper.getZoneSize(zone);
    }

    public static long getZoneSize(Zone zone) {
        if (zone != null) {
            return zone.getZoneItems().getSize();
        }
        return -1L;
    }

    public static boolean isPageModifiable(String pageId) {
        try {
            AmetysObject resolveById = _ametysObjectResolver.resolveById(pageId);
            return resolveById instanceof ModifiablePage;
        }
        catch (AmetysRepositoryException ametysRepositoryException) {
            return false;
        }
    }

    public static NodeList findPagesIdsByTagInDefaultWorkspace(String tag) {
        return AmetysFrontEditionHelper.findPagesIdsByTagInDefaultWorkspace(tag, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NodeList findPagesIdsByTagInDefaultWorkspace(String tag, boolean checkReadAccess) {
        Request request = ContextHelper.getRequest((Context)_context);
        String currentWsp = RequestAttributeWorkspaceSelector.getForcedWorkspace((Request)request);
        try {
            RequestAttributeWorkspaceSelector.setForcedWorkspace((Request)request, (String)"default");
            NodeList nodeList = org.ametys.web.transformation.xslt.AmetysXSLTHelper.findPagesIdsByTag((String)tag, (boolean)checkReadAccess);
            return nodeList;
        }
        finally {
            RequestAttributeWorkspaceSelector.setForcedWorkspace((Request)request, (String)currentWsp);
        }
    }

    public static NodeList findPagesIdsByTagInDefaultWorkspace(String sitename, String lang, String tag) {
        return AmetysFrontEditionHelper.findPagesIdsByTagInDefaultWorkspace(sitename, lang, tag, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NodeList findPagesIdsByTagInDefaultWorkspace(String sitename, String lang, String tag, boolean checkReadAccess) {
        Request request = ContextHelper.getRequest((Context)_context);
        String currentWsp = RequestAttributeWorkspaceSelector.getForcedWorkspace((Request)request);
        try {
            RequestAttributeWorkspaceSelector.setForcedWorkspace((Request)request, (String)"default");
            NodeList nodeList = org.ametys.web.transformation.xslt.AmetysXSLTHelper.findPagesIdsByTag((String)sitename, (String)lang, (String)tag, (boolean)checkReadAccess);
            return nodeList;
        }
        finally {
            RequestAttributeWorkspaceSelector.setForcedWorkspace((Request)request, (String)currentWsp);
        }
    }
}

