/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.frontedition;

import org.ametys.core.upload.Upload;
import org.ametys.core.upload.UploadManager;

/**
 * Action for uploading a file and store it using the {@link UploadManager} from FO edition.
 */
public class UploadAction extends org.ametys.plugins.core.upload.UploadAction
{
    @Override
    protected String _getUrlForView (Upload upload)
    {
        return "/_plugins/core/upload/file?id=" + upload.getId();
    }
    
    @Override
    protected String _getUrlForDownload (Upload upload)
    {
        return "/_plugins/core/upload/file?id=" + upload.getId() + "&download=true";
    }
}
