/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.frontnotification.userprefs;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.userpref.UserPreferencesException;
import org.ametys.core.userpref.UserPreferencesManager;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractItemsAction
extends ServiceableAction {
    public static final String FLASHINFO_USER_PREF_ITEM_IDS = "flashInfoItemIds";
    protected CurrentUserProvider _currentUserProvider;
    protected UserPreferencesManager _userPrefManager;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._currentUserProvider = (CurrentUserProvider)smanager.lookup(CurrentUserProvider.ROLE);
        this._userPrefManager = (UserPreferencesManager)smanager.lookup(UserPreferencesManager.ROLE + ".FO");
    }

    protected List<String> getReadItems(UserIdentity user, String siteName) throws UserPreferencesException {
        HashMap<String, String> contextVars = new HashMap<String, String>();
        contextVars.put("siteName", siteName);
        String contentIdsAsStr = this._userPrefManager.getUserPreferenceAsString(user, "/sites/" + siteName, contextVars, FLASHINFO_USER_PREF_ITEM_IDS);
        if (StringUtils.isNotBlank((CharSequence)contentIdsAsStr)) {
            return Arrays.asList(StringUtils.split((String)contentIdsAsStr, (String)","));
        }
        return Collections.emptyList();
    }

    protected void saveReadItems(UserIdentity owner, List<String> itemIds, String siteName) throws UserPreferencesException {
        HashMap<String, String> contextVars = new HashMap<String, String>();
        contextVars.put("siteName", siteName);
        this._userPrefManager.addUserPreference(owner, "/sites/" + siteName, contextVars, FLASHINFO_USER_PREF_ITEM_IDS, StringUtils.join(itemIds, (String)","));
    }
}

