/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.frontnotification.userprefs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;

import org.ametys.core.cocoon.JSonReader;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.userpref.UserPreferencesException;

import org.ametys.web.WebHelper;

/**
 * Get the ODF cart items saved in user preferences
 *
 */
public class GetReadItemsAction extends AbstractItemsAction
{
    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception
    {
        Request request = ObjectModelHelper.getRequest(objectModel);

        List<String> readItems = new ArrayList<>();
        
        String siteName = WebHelper.getSiteName(request);
        
        UserIdentity owner = _currentUserProvider.getUser();
        if (owner != null)
        {
            try
            {
                readItems = getReadItems(owner, siteName);
            }
            catch (UserPreferencesException e)
            {
                getLogger().error("Failed to get flash info read items for current user " + owner, e);
            }
        }
        
        Map<String, Object> result = new HashMap<>();
        result.put("items", readItems);
        result.put("isAnonymous", owner == null);
        
        request.setAttribute(JSonReader.OBJECT_TO_READ, result);
        return EMPTY_MAP;
    }
}
