/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.glossary;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.ametys.plugins.glossary.DefaultDefinitionFactory;
import org.ametys.plugins.glossary.Definition;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.jcr.SimpleAmetysObject;
import org.ametys.plugins.repository.jcr.SimpleAmetysObjectFactory;
import org.ametys.web.repository.SiteAwareAmetysObject;
import org.ametys.web.repository.site.Site;
import org.apache.commons.lang3.ArrayUtils;

public class DefaultDefinition
extends SimpleAmetysObject<DefaultDefinitionFactory>
implements Definition,
SiteAwareAmetysObject {
    public static final String ATTRIBUTE_WORD = "ametys-internal:word";
    public static final String ATTRIBUTE_VARIANTS = "ametys-internal:variants";
    public static final String ATTRIBUTE_CONTENT = "ametys-internal:content";
    public static final String ATTRIBUTE_DISPLAY = "ametys-internal:display";
    public static final String ATTRIBUTE_THEMES = "ametys-internal:themes";

    public DefaultDefinition(Node node, String parentPath, DefaultDefinitionFactory factory) {
        super(node, parentPath, (SimpleAmetysObjectFactory)factory);
    }

    @Override
    public String getWord() throws AmetysRepositoryException {
        try {
            return this.getNode().getProperty(ATTRIBUTE_WORD).getString();
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error getting the word property.", (Throwable)e);
        }
    }

    @Override
    public void setWord(String word) throws AmetysRepositoryException {
        try {
            this.getNode().setProperty(ATTRIBUTE_WORD, word);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error setting the word property.", (Throwable)e);
        }
    }

    @Override
    public Set<String> getVariants() throws AmetysRepositoryException {
        try {
            Value[] values;
            LinkedHashSet<String> variants = new LinkedHashSet<String>();
            for (Value value : values = this.getNode().getProperty(ATTRIBUTE_VARIANTS).getValues()) {
                variants.add(value.getString());
            }
            return variants;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error getting the variants property.", (Throwable)e);
        }
    }

    @Override
    public void setVariants(Collection<String> variants) throws AmetysRepositoryException {
        try {
            String[] values = variants.toArray(new String[variants.size()]);
            this.getNode().setProperty(ATTRIBUTE_VARIANTS, values);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error setting the variants property.", (Throwable)e);
        }
    }

    @Override
    public String getContent() throws AmetysRepositoryException {
        try {
            return this.getNode().getProperty(ATTRIBUTE_CONTENT).getString();
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error getting the content property.", (Throwable)e);
        }
    }

    @Override
    public void setContent(String content) throws AmetysRepositoryException {
        try {
            this.getNode().setProperty(ATTRIBUTE_CONTENT, content);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error setting the content property.", (Throwable)e);
        }
    }

    @Override
    public boolean displayOnText() throws AmetysRepositoryException {
        try {
            return this.getNode().getProperty(ATTRIBUTE_DISPLAY).getBoolean();
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error getting the display property.", (Throwable)e);
        }
    }

    @Override
    public void setDisplayOnText(boolean displayOnText) throws AmetysRepositoryException {
        try {
            this.getNode().setProperty(ATTRIBUTE_DISPLAY, displayOnText);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error setting the display property.", (Throwable)e);
        }
    }

    @Override
    public Set<String> getAllForms() throws AmetysRepositoryException {
        HashSet<String> allForms = new HashSet<String>();
        allForms.add(this.getWord());
        allForms.addAll(this.getVariants());
        return allForms;
    }

    public Site getSite() throws AmetysRepositoryException {
        return (Site)this.getParent().getParent().getParent().getParent().getParent();
    }

    public String getSiteName() throws AmetysRepositoryException {
        return this.getSite().getName();
    }

    public String getLanguage() {
        return this.getParent().getParent().getName();
    }

    @Override
    public String[] getThemes() throws AmetysRepositoryException {
        return this._getListFromAttributeName(ATTRIBUTE_THEMES);
    }

    @Override
    public void setThemes(String[] themes) throws AmetysRepositoryException {
        try {
            this.getNode().setProperty(ATTRIBUTE_THEMES, themes);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("An error occurred while trying to set the property 'ametys-internal:themes'.", (Throwable)e);
        }
    }

    @Override
    public void removeTheme(String themeId) throws AmetysRepositoryException {
        try {
            Object[] themes = this.getThemes();
            String[] updatedThemes = (String[])ArrayUtils.removeElement((Object[])themes, (Object)themeId);
            this.getNode().setProperty(ATTRIBUTE_THEMES, updatedThemes);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error removing theme of id " + themeId, (Throwable)e);
        }
    }

    private String[] _getListFromAttributeName(String attributeName) {
        try {
            if (this.getNode().hasProperty(attributeName)) {
                Value[] values = this.getNode().getProperty(attributeName).getValues();
                String[] list = new String[values.length];
                for (int i = 0; i < values.length; ++i) {
                    list[i] = values[i].getString();
                }
                return list;
            }
            return new String[0];
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("An error occurred while trying to get the property '" + attributeName + "'.", (Throwable)e);
        }
    }
}

