/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.glossary;

import java.io.IOException;
import java.text.Normalizer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.plugins.glossary.DefaultDefinition;
import org.ametys.plugins.glossary.GlossaryHelper;
import org.ametys.plugins.glossary.theme.ThemeExpression;
import org.ametys.plugins.glossary.theme.ThemesDAO;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.data.holder.ModelAwareDataHolder;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.OrExpression;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.ZoneItem;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class DefinitionsGenerator
extends ServiceableGenerator {
    private ThemesDAO _themesDAO;
    private AmetysObjectResolver _ametysObjectResolver;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._themesDAO = (ThemesDAO)((Object)serviceManager.lookup(ThemesDAO.ROLE));
        this._ametysObjectResolver = (AmetysObjectResolver)serviceManager.lookup(AmetysObjectResolver.ROLE);
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String siteName = this.parameters.getParameter("siteName", (String)request.getAttribute("site"));
        String language = this.parameters.getParameter("language", (String)request.getAttribute("sitemapLanguage"));
        String letter = this.parameters.getParameter("letter", request.getParameter("letter"));
        letter = StringUtils.isBlank((CharSequence)letter) ? "A" : letter.toUpperCase();
        Page page = (Page)request.getAttribute(Page.class.getName());
        ZoneItem zoneItem = (ZoneItem)request.getAttribute(ZoneItem.class.getName());
        ModelAwareDataHolder serviceParameters = zoneItem.getServiceParameters();
        String[] themes = (String[])serviceParameters.getValue("themes", false, (Object)new String[0]);
        this.contentHandler.startDocument();
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute("siteName", siteName);
        attrs.addCDATAAttribute("language", language);
        attrs.addCDATAAttribute("letter", letter);
        if (page != null) {
            attrs.addCDATAAttribute("page", page.getId());
        }
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"wordDefinitions", (Attributes)attrs);
        Expression themeExpression = this._getThemeExpression(siteName, language, themes);
        String definitionQuery = GlossaryHelper.getDefinitionQuery(siteName, language, themeExpression);
        try (AmetysObjectIterable definitions = this._ametysObjectResolver.query(definitionQuery);){
            for (DefaultDefinition definition : definitions) {
                this.saxDefinition(definition);
            }
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"wordDefinitions");
        this.contentHandler.endDocument();
    }

    protected Expression _getThemeExpression(String siteName, String language, String[] themes) {
        Expression[] themeExpressions = (ThemeExpression[])Arrays.stream(themes).filter(StringUtils::isNotBlank).filter(id -> this.themeExists((String)id, siteName, language)).map(id -> new ThemeExpression((String)id)).toArray(ThemeExpression[]::new);
        return themeExpressions.length == 0 ? null : new OrExpression(themeExpressions);
    }

    protected void saxDefinition(DefaultDefinition definition) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute("id", definition.getId());
        String word = definition.getWord();
        if (StringUtils.isNotEmpty((CharSequence)word)) {
            String firstLetter = Normalizer.normalize(word.substring(0, 1), Normalizer.Form.NFD).replaceAll("\\p{InCombiningDiacriticalMarks}+", "");
            attrs.addCDATAAttribute("firstLetter", firstLetter.toUpperCase());
        }
        attrs.addCDATAAttribute("word", definition.getWord());
        attrs.addCDATAAttribute("variantsText", StringUtils.join(definition.getVariants(), (String)", "));
        attrs.addCDATAAttribute("displayOnText", Boolean.toString(definition.displayOnText()));
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"wordDefinition", (Attributes)attrs);
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"variants");
        for (String variant : definition.getVariants()) {
            AttributesImpl variantAttrs = new AttributesImpl();
            variantAttrs.addCDATAAttribute("word", variant);
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"variant", (Attributes)variantAttrs);
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"variants");
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"content", (String)definition.getContent());
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"wordDefinition");
    }

    public boolean themeExists(String themeName, String siteName, String language) {
        if (StringUtils.isBlank((CharSequence)themeName)) {
            return false;
        }
        HashMap<String, String> contextualParameters = new HashMap<String, String>();
        contextualParameters.put("language", language);
        contextualParameters.put("siteName", siteName);
        List checkTags = this._themesDAO.checkTags(List.of(themeName), false, Collections.EMPTY_MAP, contextualParameters);
        return !checkTags.isEmpty();
    }
}

