/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.glossary;

import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ametys.core.ui.Callable;
import org.ametys.plugins.glossary.DefaultDefinition;
import org.ametys.plugins.glossary.GlossaryHelper;
import org.ametys.plugins.glossary.theme.ThemesDAO;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.ModifiableAmetysObject;
import org.ametys.plugins.repository.ModifiableTraversableAmetysObject;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.repository.jcr.NameHelper;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.web.repository.site.SiteManager;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;

public class GlossaryDAO
extends AbstractLogEnabled
implements Serviceable,
Component {
    public static final String ROLE = GlossaryDAO.class.getName();
    protected SiteManager _siteManager;
    protected AmetysObjectResolver _resolver;
    ThemesDAO _themeDAO;

    public void service(ServiceManager manager) throws ServiceException {
        this._siteManager = (SiteManager)manager.lookup(SiteManager.ROLE);
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._themeDAO = (ThemesDAO)((Object)manager.lookup(ThemesDAO.ROLE));
    }

    @Callable(rights={"Glossary_Rights_Definitions_Handle"})
    public Map<String, Object> getDefinitions(String siteName, String lang) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> definitions = new ArrayList<Map<String, Object>>();
        ModifiableTraversableAmetysObject definitionsNode = GlossaryHelper.getDefinitionsNode(this._siteManager.getSite(siteName), lang);
        try (AmetysObjectIterable wordDefinitions = definitionsNode.getChildren();){
            for (DefaultDefinition wordDefinition : wordDefinitions) {
                definitions.add(this.getDefinition(wordDefinition));
            }
        }
        result.put("definitions", definitions);
        return result;
    }

    @Callable(rights={"Glossary_Rights_Definitions_Handle"})
    public Map<String, Object> getDefinition(String id) {
        DefaultDefinition wordDefinition = (DefaultDefinition)this._resolver.resolveById(id);
        return this.getDefinition(wordDefinition);
    }

    public Map<String, Object> getDefinition(DefaultDefinition wordDefinition) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("id", wordDefinition.getId());
        properties.put("lang", wordDefinition.getLanguage());
        properties.put("siteName", wordDefinition.getSiteName());
        properties.put("word", wordDefinition.getWord());
        String firstLetter = Normalizer.normalize(wordDefinition.getWord().substring(0, 1), Normalizer.Form.NFD).replaceAll("\\p{InCombiningDiacriticalMarks}+", "");
        properties.put("firstLetter", firstLetter);
        properties.put("variants", wordDefinition.getVariants());
        properties.put("content", wordDefinition.getContent());
        properties.put("displayOnText", wordDefinition.displayOnText());
        ArrayList themesList = new ArrayList();
        for (String themeId : wordDefinition.getThemes()) {
            try {
                I18nizableText themeTitle = this._themeDAO.getThemeTitle(themeId, wordDefinition.getSiteName(), wordDefinition.getLanguage());
                HashMap<String, String> themeData = new HashMap<String, String>();
                themeData.put("id", themeId);
                themeData.put("label", (String)themeTitle);
                themesList.add(themeData);
            }
            catch (UnknownAmetysObjectException unknownAmetysObjectException) {
                // empty catch block
            }
        }
        properties.put("themes", themesList);
        return properties;
    }

    @Callable(rights={"Glossary_Rights_Definitions_Handle"})
    public Map<String, String> createDefinition(String word, String variants, String content, List<String> themes, Boolean display, String siteName, String language) {
        HashMap<String, String> result = new HashMap<String, String>();
        String capitalizedWord = StringUtils.capitalize((String)word);
        ArrayList<String> variantList = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)variants)) {
            for (String variant : StringUtils.split((String)variants, (String)",")) {
                String trimVariant = variant.trim();
                if (!StringUtils.isNotEmpty((CharSequence)trimVariant)) continue;
                variantList.add(StringUtils.capitalize((String)trimVariant));
            }
        }
        if (this._wordExists(capitalizedWord, siteName, language)) {
            result.put("error", "word-already-exists");
            return result;
        }
        for (String variant : variantList) {
            if (!this._wordExists(variant, siteName, language)) continue;
            result.put("error", "word-already-exists");
            return result;
        }
        ModifiableTraversableAmetysObject rootNode = GlossaryHelper.getDefinitionsNode(this._siteManager.getSite(siteName), language);
        String originalName = NameHelper.filterName((String)capitalizedWord);
        Object name = originalName;
        int index = 2;
        while (rootNode.hasChild((String)name)) {
            name = originalName + "-" + index++;
        }
        DefaultDefinition def = (DefaultDefinition)rootNode.createChild((String)name, "ametys:wordDefinition");
        def.setWord(capitalizedWord);
        def.setVariants(variantList);
        def.setContent(content);
        def.setThemes(themes.toArray(new String[themes.size()]));
        def.setDisplayOnText(display);
        rootNode.saveChanges();
        result.put("id", def.getId());
        return result;
    }

    @Callable(rights={"Glossary_Rights_Definitions_Handle"})
    public Map<String, String> editDefinition(String id, String word, String variants, String content, List<String> themes, Boolean display, String siteName, String language) {
        HashMap<String, String> result = new HashMap<String, String>();
        String capitalizedWord = StringUtils.capitalize((String)word);
        ArrayList<String> variantList = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)variants)) {
            for (String variant : StringUtils.split((String)variants, (String)",")) {
                String trimVariant = variant.trim();
                if (!StringUtils.isNotEmpty((CharSequence)trimVariant)) continue;
                variantList.add(StringUtils.capitalize((String)variant.trim()));
            }
        }
        try {
            DefaultDefinition definition = (DefaultDefinition)this._resolver.resolveById(id);
            Set<String> allForms = definition.getAllForms();
            if (!allForms.contains(word) && this._wordExists(word, siteName, language)) {
                return Collections.singletonMap("error", "word-already-exists");
            }
            for (String variant : variantList) {
                if (allForms.contains(variant) || !this._wordExists(variant, siteName, language)) continue;
                return Collections.singletonMap("error", "word-already-exists");
            }
            definition.setWord(capitalizedWord.trim());
            definition.setVariants(variantList);
            definition.setContent(content);
            definition.setThemes(themes.toArray(new String[themes.size()]));
            definition.setDisplayOnText(display);
            definition.saveChanges();
            result.put("id", definition.getId());
        }
        catch (UnknownAmetysObjectException e) {
            result.put("error", "unknown-definition");
            this.getLogger().error("Unable to edit definition of id '" + id + ", because it does not not exist.", (Throwable)e);
        }
        return result;
    }

    @Callable(rights={"Glossary_Rights_Definitions_Handle"})
    public Map<String, Object> deleteDefinitions(ArrayList<String> ids) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<String> deletedDefinitions = new ArrayList<String>();
        ArrayList<String> unknownIds = new ArrayList<String>();
        for (String id : ids) {
            try {
                DefaultDefinition definition = (DefaultDefinition)this._resolver.resolveById(id);
                ModifiableAmetysObject parent = (ModifiableAmetysObject)definition.getParent();
                definition.remove();
                parent.saveChanges();
                deletedDefinitions.add(id);
            }
            catch (UnknownAmetysObjectException e) {
                result.put("error", "unknown-definition");
                this.getLogger().error("Unable to delete the definition of id '" + id + ", because it does not exist.", (Throwable)e);
                unknownIds.add(id);
            }
        }
        result.put("ids", deletedDefinitions);
        result.put("unknown-ids", unknownIds);
        return result;
    }

    protected boolean _wordExists(String word, String siteName, String language) throws AmetysRepositoryException {
        String xpathQuery = GlossaryHelper.getWordExistsQuery(siteName, language, word);
        try (AmetysObjectIterable defs = this._resolver.query(xpathQuery);){
            boolean bl = defs.iterator().hasNext();
            return bl;
        }
    }
}

