/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.glossary;

import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.ModifiableTraversableAmetysObject;
import org.ametys.plugins.repository.query.SortCriteria;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.web.repository.site.Site;
import org.apache.commons.lang3.StringUtils;

public final class GlossaryHelper {
    public static final String GLOSSARY_PAGE_TAG = "GLOSSARY";
    private static final String __PLUGIN_NODE_NAME = "glossary";
    private static final String __DEFINITIONS_NODE_NAME = "ametys:wordDefinitions";

    private GlossaryHelper() {
    }

    public static ModifiableTraversableAmetysObject getPluginNode(Site site) throws AmetysRepositoryException {
        try {
            ModifiableTraversableAmetysObject pluginsNode = site.getRootPlugins();
            return GlossaryHelper.getOrCreateNode(pluginsNode, __PLUGIN_NODE_NAME, "ametys:unstructured");
        }
        catch (AmetysRepositoryException e) {
            throw new AmetysRepositoryException("Error getting the glossary plugin node for site " + site.getName(), (Throwable)e);
        }
    }

    public static ModifiableTraversableAmetysObject getDefinitionsNode(Site site, String language) throws AmetysRepositoryException {
        try {
            ModifiableTraversableAmetysObject pluginNode = GlossaryHelper.getPluginNode(site);
            ModifiableTraversableAmetysObject langNode = GlossaryHelper.getOrCreateNode(pluginNode, language, "ametys:unstructured");
            return GlossaryHelper.getOrCreateNode(langNode, __DEFINITIONS_NODE_NAME, __DEFINITIONS_NODE_NAME);
        }
        catch (AmetysRepositoryException e) {
            throw new AmetysRepositoryException("Error getting the word definitions node for site " + site.getName() + " and language " + language, (Throwable)e);
        }
    }

    public static String getPluginNodePath(String siteName) {
        return String.format("//element(%s, ametys:site)/ametys-internal:plugins/%s", siteName, __PLUGIN_NODE_NAME);
    }

    public static String getDefinitionsNodePath(String siteName, String language) {
        return GlossaryHelper.getPluginNodePath(siteName) + "/" + language + "/ametys:wordDefinitions";
    }

    public static String getDefinitionQuery(String siteName, String language, Expression expression) {
        SortCriteria sortCriteria = new SortCriteria();
        sortCriteria.addJCRPropertyCriterion("ametys-internal:word", true, true);
        return GlossaryHelper.getDefinitionQuery(siteName, language, expression, sortCriteria);
    }

    public static String getDefinitionQuery(String siteName, String language, Expression expression, SortCriteria sortCriteria) {
        String predicats = null;
        if (expression != null) {
            predicats = StringUtils.trimToNull((String)expression.build());
        }
        String xpathQuery = GlossaryHelper.getDefinitionsNodePath(siteName, language) + "/element(*, ametys:wordDefinition)" + (String)(predicats != null ? "[" + predicats + "]" : "") + (String)(sortCriteria != null ? " " + sortCriteria.build() : "");
        return xpathQuery;
    }

    public static String getWordExistsQuery(String siteName, String language, String word) {
        String lowerWord = StringUtils.replace((String)word, (String)"'", (String)"''").toLowerCase();
        return GlossaryHelper.getDefinitionsNodePath(siteName, language) + "/element(*, ametys:wordDefinition)[fn:lower-case(@ametys-internal:word) = '" + lowerWord + "' or fn:lower-case(@ametys-internal:variants) = '" + lowerWord + "']";
    }

    public static String getFirstLetterDefQuery(String siteName, String language, String letter) {
        String lowerLetter = letter.toLowerCase();
        return GlossaryHelper.getDefinitionsNodePath(siteName, language) + "/element(*, ametys:wordDefinition)[jcr:like(fn:lower-case(@ametys-internal:word), '" + lowerLetter + "%')] order by @ametys-internal:word";
    }

    public static String getNonAlphaFirstLetterDefQuery(String siteName, String language) {
        return GlossaryHelper.getDefinitionsNodePath(siteName, language) + "/element(*, ametys:wordDefinition)[not(jcr:like(fn:lower-case(@ametys-internal:word), 'a%')) and not(jcr:like(fn:lower-case(@ametys-internal:word), 'b%'))and not(jcr:like(fn:lower-case(@ametys-internal:word), 'c%'))and not(jcr:like(fn:lower-case(@ametys-internal:word), 'd%'))and not(jcr:like(fn:lower-case(@ametys-internal:word), 'e%'))and not(jcr:like(fn:lower-case(@ametys-internal:word), 'f%'))and not(jcr:like(fn:lower-case(@ametys-internal:word), 'g%'))and not(jcr:like(fn:lower-case(@ametys-internal:word), 'h%'))and not(jcr:like(fn:lower-case(@ametys-internal:word), 'u%'))and not(jcr:like(fn:lower-case(@ametys-internal:word), 'j%'))and not(jcr:like(fn:lower-case(@ametys-internal:word), 'k%'))and not(jcr:like(fn:lower-case(@ametys-internal:word), 'l%'))and not(jcr:like(fn:lower-case(@ametys-internal:word), 'm%'))and not(jcr:like(fn:lower-case(@ametys-internal:word), 'n%'))and not(jcr:like(fn:lower-case(@ametys-internal:word), 'o%'))and not(jcr:like(fn:lower-case(@ametys-internal:word), 'p%'))and not(jcr:like(fn:lower-case(@ametys-internal:word), 'q%'))and not(jcr:like(fn:lower-case(@ametys-internal:word), 'r%'))and not(jcr:like(fn:lower-case(@ametys-internal:word), 's%'))and not(jcr:like(fn:lower-case(@ametys-internal:word), 't%'))and not(jcr:like(fn:lower-case(@ametys-internal:word), 'u%'))and not(jcr:like(fn:lower-case(@ametys-internal:word), 'v%'))and not(jcr:like(fn:lower-case(@ametys-internal:word), 'w%'))and not(jcr:like(fn:lower-case(@ametys-internal:word), 'x%'))and not(jcr:like(fn:lower-case(@ametys-internal:word), 'y%'))and not(jcr:like(fn:lower-case(@ametys-internal:word), 'z%'))] order by @ametys-internal:word";
    }

    private static ModifiableTraversableAmetysObject getOrCreateNode(ModifiableTraversableAmetysObject parentNode, String nodeName, String nodeType) throws AmetysRepositoryException {
        ModifiableTraversableAmetysObject definitionsNode;
        if (parentNode.hasChild(nodeName)) {
            definitionsNode = (ModifiableTraversableAmetysObject)parentNode.getChild(nodeName);
        } else {
            definitionsNode = (ModifiableTraversableAmetysObject)parentNode.createChild(nodeName, nodeType);
            parentNode.saveChanges();
        }
        return definitionsNode;
    }
}

