/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.glossary.theme;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.ametys.cms.tag.AbstractTagsDAO;
import org.ametys.cms.tag.Tag;
import org.ametys.cms.tag.TagProvider;
import org.ametys.cms.tag.jcr.AbstractJCRTagsDAO;
import org.ametys.plugins.glossary.theme.JCRThemeProvider;
import org.ametys.plugins.glossary.theme.JCRThemesDAO;
import org.ametys.plugins.glossary.theme.ThemeProviderExtensionPoint;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang3.StringUtils;

public class ThemesDAO
extends AbstractTagsDAO {
    public static final String ROLE = ThemesDAO.class.getName();
    protected JCRThemesDAO _jcrThemesDAO;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._jcrThemesDAO = (JCRThemesDAO)((Object)manager.lookup(JCRThemesDAO.ROLE));
    }

    public String getTagProviderEPRole() {
        return ThemeProviderExtensionPoint.ROLE;
    }

    protected AbstractJCRTagsDAO _getTagJCRDAO() {
        return this._jcrThemesDAO;
    }

    protected List<TagProvider<? extends Tag>> getCustomTagProvider() {
        ArrayList<TagProvider<? extends Tag>> providers = new ArrayList<TagProvider<? extends Tag>>();
        providers.add((TagProvider)this._tagProviderExtPt.getExtension(JCRThemeProvider.class.getName()));
        return providers;
    }

    public I18nizableText getThemeTitle(String themeName, String siteName, String language) {
        HashMap<String, String> contextualParameters = new HashMap<String, String>();
        contextualParameters.put("language", language);
        contextualParameters.put("siteName", siteName);
        if (this.themeExists(themeName, siteName, language)) {
            Tag tag = this.getTag(themeName, contextualParameters);
            return tag.getTitle();
        }
        this.getLogger().warn("Can't find theme with name " + themeName + " for site " + siteName + " and language " + language);
        return null;
    }

    public boolean themeExists(String themeName, String siteName, String language) {
        if (StringUtils.isBlank((CharSequence)themeName)) {
            return false;
        }
        HashMap<String, String> contextualParameters = new HashMap<String, String>();
        contextualParameters.put("language", language);
        contextualParameters.put("siteName", siteName);
        List checkTags = this.checkTags(List.of(themeName), false, Collections.EMPTY_MAP, contextualParameters);
        return !checkTags.isEmpty();
    }
}

