/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.glossary.transformation;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ametys.cms.repository.Content;
import org.ametys.cms.transformation.AbstractEnhancementHandler;
import org.ametys.cms.transformation.URIResolverExtensionPoint;
import org.ametys.plugins.glossary.DefaultDefinition;
import org.ametys.plugins.glossary.Definition;
import org.ametys.plugins.glossary.GlossaryHelper;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectIterator;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.ModifiableTraversableAmetysObject;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.web.WebHelper;
import org.ametys.web.renderingcontext.RenderingContext;
import org.ametys.web.renderingcontext.RenderingContextHandler;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.PageQueryHelper;
import org.ametys.web.repository.site.SiteManager;
import org.ametys.web.tags.TagExpression;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.i18n.I18nUtils;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class DefinitionEnhancementHandler
extends AbstractEnhancementHandler
implements Component,
Serviceable,
Contextualizable {
    public static final String ROLE = DefinitionEnhancementHandler.class.getName();
    private static final Set<String> __IGNORE_TAGS = new HashSet<String>();
    private static final Set<String> __IGNORE_NAMESPACES;
    protected AmetysObjectResolver _resolver;
    protected SiteManager _siteManager;
    protected URIResolverExtensionPoint _uriResolver;
    protected Context _context;
    protected Map<String, Definition> _definitions;
    protected String _glossaryHref;
    protected Map<String, Integer> _ignoredNamespaceStack;
    private int _inIgnoredTag;
    private RenderingContextHandler _renderingContextHandler;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)serviceManager.lookup(AmetysObjectResolver.ROLE);
        this._uriResolver = (URIResolverExtensionPoint)serviceManager.lookup(URIResolverExtensionPoint.ROLE);
        this._siteManager = (SiteManager)serviceManager.lookup(SiteManager.ROLE);
        this._renderingContextHandler = (RenderingContextHandler)serviceManager.lookup(RenderingContextHandler.ROLE);
    }

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public void startDocument() throws SAXException {
        super.startDocument();
        this._glossaryHref = null;
        this._inIgnoredTag = 0;
        this._ignoredNamespaceStack = new HashMap<String, Integer>();
        for (String ignoredNamespace : __IGNORE_NAMESPACES) {
            this._ignoredNamespaceStack.put(ignoredNamespace, 0);
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        super.startElement(uri, localName, qName, atts);
        if (__IGNORE_TAGS.contains(localName.toLowerCase())) {
            ++this._inIgnoredTag;
        }
        if (__IGNORE_NAMESPACES.contains(uri)) {
            this._ignoredNamespaceStack.put(uri, this._ignoredNamespaceStack.get(uri) + 1);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (__IGNORE_NAMESPACES.contains(uri)) {
            this._ignoredNamespaceStack.put(uri, this._ignoredNamespaceStack.get(uri) - 1);
        }
        if (__IGNORE_TAGS.contains(localName.toLowerCase())) {
            --this._inIgnoredTag;
        }
        super.endElement(uri, localName, qName);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this._searchCharacters()) {
            Request request = ContextHelper.getRequest((Context)this._context);
            Content content = (Content)request.getAttribute(Content.class.getName());
            this._charactersWithDefinitions(ch, start, length, content);
        } else {
            super.characters(ch, start, length);
        }
    }

    protected boolean _searchCharacters() {
        boolean search = this._inIgnoredTag < 1 && !this._inUnmodifiableContent;
        Iterator<Integer> nsIt = this._ignoredNamespaceStack.values().iterator();
        while (nsIt.hasNext() && search) {
            if (nsIt.next() <= 0) continue;
            search = false;
        }
        return search;
    }

    protected void _charactersWithDefinitions(char[] ch, int start, int length, Content content) throws SAXException {
        Map<String, Definition> words;
        Request request = ContextHelper.getRequest((Context)this._context);
        String siteName = WebHelper.getSiteName((Request)request, (AmetysObject)content);
        String language = content.getLanguage();
        if (language == null) {
            language = (String)request.getAttribute("sitemapLanguage");
        }
        if (language == null) {
            Map objectModel = ContextHelper.getObjectModel((Context)this._context);
            language = I18nUtils.findLocale((Map)objectModel, (String)"locale", null, (Locale)Locale.getDefault(), (boolean)true).getLanguage();
        }
        if (!(words = this._getDefinitions(siteName, language)).isEmpty()) {
            Pattern pattern = this._getWordsPattern(words.keySet());
            String str = new String(ch, start, length);
            Matcher matcher = pattern.matcher(str);
            int previousMatch = start;
            while (matcher.find()) {
                Object pageLink = this._getGlossaryPageHref(siteName, language);
                int startIndex = matcher.start();
                int endIndex = matcher.end();
                int wordIndex = start + startIndex;
                String word = str.substring(startIndex, endIndex).toLowerCase();
                Definition definition = words.get(word);
                if (definition != null && StringUtils.isNotEmpty((CharSequence)word)) {
                    String defContent = definition.getContent();
                    AttributesImpl attrs = new AttributesImpl();
                    attrs.addCDATAAttribute("title", defContent);
                    super.characters(ch, previousMatch, wordIndex - previousMatch);
                    XMLUtils.startElement((ContentHandler)this._contentHandler, (String)"dfn", (Attributes)attrs);
                    if (StringUtils.isNotEmpty((CharSequence)pageLink)) {
                        RenderingContext currentContext = this._renderingContextHandler.getRenderingContext();
                        if (currentContext != RenderingContext.BACK) {
                            pageLink = (String)pageLink + "?letter=" + word.charAt(0) + "#" + definition.getWord();
                        }
                        AttributesImpl linkAttrs = new AttributesImpl();
                        linkAttrs.addCDATAAttribute("href", (String)pageLink);
                        XMLUtils.startElement((ContentHandler)this._contentHandler, (String)"a", (Attributes)linkAttrs);
                    }
                    super.characters(ch, wordIndex, endIndex - startIndex);
                    if (StringUtils.isNotEmpty((CharSequence)pageLink)) {
                        XMLUtils.endElement((ContentHandler)this._contentHandler, (String)"a");
                    }
                    XMLUtils.endElement((ContentHandler)this._contentHandler, (String)"dfn");
                }
                previousMatch = start + endIndex;
            }
            super.characters(ch, previousMatch, start + length - previousMatch);
        } else {
            super.characters(ch, start, length);
        }
    }

    protected Map<String, Definition> _getDefinitions(String siteName, String lang) {
        if (this._definitions == null) {
            this._definitions = this._getWordsAndDefinitions(siteName, lang);
        }
        return Collections.unmodifiableMap(this._definitions);
    }

    protected Map<String, Definition> _getWordsAndDefinitions(String siteName, String lang) {
        HashMap<String, Definition> words = new HashMap<String, Definition>();
        ModifiableTraversableAmetysObject definitionsNode = GlossaryHelper.getDefinitionsNode(this._siteManager.getSite(siteName), lang);
        AmetysObjectIterable definitions = definitionsNode.getChildren();
        for (DefaultDefinition definition : definitions) {
            if (!definition.displayOnText()) continue;
            for (String word : definition.getAllForms()) {
                words.put(word.toLowerCase(), definition);
            }
        }
        return words;
    }

    protected Pattern _getWordsPattern(Set<String> words) {
        StringBuilder pattern = new StringBuilder();
        pattern.append("\\b(?:");
        Iterator<String> wordIt = words.iterator();
        int i = 0;
        while (wordIt.hasNext()) {
            if (i > 0) {
                pattern.append('|');
            }
            pattern.append("\\Q").append(wordIt.next()).append("\\E");
            ++i;
        }
        pattern.append(")\\b");
        return Pattern.compile(pattern.toString(), 2);
    }

    protected String _getGlossaryPageHref(String siteName, String language) {
        if (this._glossaryHref == null) {
            Page glossaryPage = this._getGlossaryPage(siteName, language);
            if (glossaryPage != null) {
                Request request = ContextHelper.getRequest((Context)this._context);
                boolean absolute = request.getAttribute("forceAbsoluteUrl") != null ? (Boolean)request.getAttribute("forceAbsoluteUrl") : false;
                this._glossaryHref = this._uriResolver.getResolverForType("page").resolve(glossaryPage.getId(), false, absolute, false);
            } else {
                this._glossaryHref = "";
            }
        }
        return this._glossaryHref;
    }

    protected Page _getGlossaryPage(String siteName, String language) {
        Page page = null;
        TagExpression glossaryExpr = new TagExpression(Expression.Operator.EQ, "GLOSSARY");
        String xpath = PageQueryHelper.getPageXPathQuery((String)siteName, (String)language, null, (Expression)glossaryExpr, null);
        try (AmetysObjectIterable pages = this._resolver.query(xpath);){
            AmetysObjectIterator it = pages.iterator();
            if (it.hasNext()) {
                page = (Page)it.next();
                if (it.hasNext()) {
                    this.getLogger().warn(String.format("More than one page is tagged 'GLOSSARY' in site %s and sitemap %s, please tag a single page.", siteName, language));
                }
            }
        }
        return page;
    }

    static {
        __IGNORE_TAGS.add("head");
        __IGNORE_TAGS.add("script");
        __IGNORE_TAGS.add("style");
        __IGNORE_TAGS.add("option");
        __IGNORE_TAGS.add("a");
        __IGNORE_TAGS.add("h1");
        __IGNORE_TAGS.add("h2");
        __IGNORE_TAGS.add("h3");
        __IGNORE_TAGS.add("h4");
        __IGNORE_TAGS.add("h5");
        __IGNORE_TAGS.add("h6");
        __IGNORE_NAMESPACES = new HashSet<String>();
        __IGNORE_NAMESPACES.add("http://apache.org/cocoon/i18n/2.1");
    }
}

