<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2011 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:exsl="http://exslt.org/common"
                xmlns:math="java.lang.Math"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                extension-element-prefixes="exsl math resolver ametys">
    
    <xsl:import href="service:web://pages/services/common.xsl"/>
    
    <xsl:param name="header" select="string(ametys:serviceParameter('header')/text())"/>
    <xsl:param name="generateEmptyLetters" select="false()"/>
    
    <xsl:variable name="uniqueId" select="substring-after(math:random(), '.')"/>
    
    <xsl:variable name="nonletter">#</xsl:variable>
    <xsl:variable name="letters"><letters><l>A</l><l>B</l><l>C</l><l>D</l><l>E</l><l>F</l><l>G</l><l>H</l><l>I</l><l>J</l><l>K</l><l>L</l><l>M</l><l>N</l><l>O</l><l>P</l><l>Q</l><l>R</l><l>S</l><l>T</l><l>U</l><l>V</l><l>W</l><l>X</l><l>Y</l><l>Z</l></letters></xsl:variable>
    
    <xsl:variable name="raw-is-title-visible">        
        <xsl:call-template name="common-service-head-title-content">
            <xsl:with-param name="title" select="$header"/>                    
        </xsl:call-template>
    </xsl:variable>    
    <xsl:variable name="is-title-visible" select="string-length($raw-is-title-visible) &gt; 0"/>
    <xsl:variable name="level">
        <xsl:choose>
            <xsl:when test="$is-title-visible">2</xsl:when>
            <xsl:otherwise>1</xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    
    <!-- Used in common.xsl -->
    <xsl:variable name="common-service-css-class-name">glossary</xsl:variable>
    <xsl:variable name="is-empty" select="not(/wordDefinitions/wordDefinition)"/> 
    <xsl:variable name="common-service-name-id">service-glossary</xsl:variable>    
    
    <xsl:template name="common-service-head-title">
        <xsl:call-template name="common-service-head-title-content">
            <xsl:with-param name="title" select="$header"/>                  
        </xsl:call-template>
    </xsl:template>  
    
    <xsl:template name="common-service-body-nonempty-content-title">
        <xsl:call-template name="common-service-body-nonempty-content-title-content">
            <xsl:with-param name="title" select="$header"/>
        </xsl:call-template>    
    </xsl:template>
    
    <xsl:template name="common-service-body-empty">
        <div class="ametys-cms-service {$common-service-css-class-name} wrapper">
            <xsl:call-template name="common-service-body-nonempty-content-title"/>
            
            <p>
                <i18n:text i18n:key="PLUGINS_GLOSSARY_SERVICE_NO_ENTRY"/>
            </p>
        </div>      
    </xsl:template>
 
    <xsl:template name="common-service-body-nonempty-content-content">
        <div id="definitions-{$uniqueId}">
            <xsl:call-template name="letters"/>
            
            <xsl:variable name="wordDefinitions" select="/wordDefinitions/wordDefinition"/>
            
            <!-- Non-letters -->
            <xsl:if test="$wordDefinitions[not(@firstLetter = exsl:node-set($letters)/letters/l)]">
                <div class="letter-definitions" id="definitions-{$uniqueId}-letter-0">
                    <a name="0"/>
                    <xsl:element name="h{$level}">
                        <xsl:attribute name="class">title-letter</xsl:attribute>
                        <xsl:value-of select="$nonletter"/>
                    </xsl:element>
                    
                    <dl>
                        <xsl:apply-templates select="$wordDefinitions[not(@firstLetter = exsl:node-set($letters)/letters/l)]">
                            <xsl:sort select="@word"/>
                        </xsl:apply-templates>
                    </dl>
                </div>
            </xsl:if>
            
            <xsl:for-each select="exsl:node-set($letters)/letters/l">
                <xsl:variable name="letter" select="."/>
                <xsl:if test="$generateEmptyLetters or $wordDefinitions[@firstLetter = $letter]">
                    <div class="letter-definitions" id="definitions-{$uniqueId}-letter-{$letter}">
                        <xsl:choose>
                            <xsl:when test="$wordDefinitions[@firstLetter = $letter]">
                                <a name="{$letter}"/>
                                <xsl:element name="h{$level}">
                                    <xsl:attribute name="class">title-letter</xsl:attribute>
                                    <xsl:value-of select="$letter"/>
                                </xsl:element>
                                
                                <dl>                
                                    <xsl:apply-templates select="$wordDefinitions[@firstLetter = $letter]">
                                        <xsl:sort select="@word"/>
                                    </xsl:apply-templates>
                                </dl>
                            </xsl:when>
                            <xsl:otherwise>
                            	<script type="text/javascript">
                            		document.write('&lt;p&gt;<i18n:text i18n:key="PLUGINS_GLOSSARY_SERVICE_NO_ENTRY_LETTER"/>&lt;/p&gt;');
                                </script>
                            </xsl:otherwise>
                        </xsl:choose>
                    </div>
                </xsl:if>
            </xsl:for-each>
        </div>
    </xsl:template>        
    
    <xsl:template match="wordDefinition">
        <dt>
            <xsl:attribute name="class"><xsl:call-template name="common-utils-class"/></xsl:attribute>
            <a name="{@word}"/>
            <xsl:value-of select="@word"/>
        </dt>
        <dd>
            <xsl:attribute name="class"><xsl:call-template name="common-utils-class"/></xsl:attribute>
            <xsl:call-template name="utils.nl2br">
                <xsl:with-param name="input" select="content"/>
            </xsl:call-template>
        </dd>
    </xsl:template>
    
    <xsl:template name="letters">
        <xsl:variable name="letter" select="/wordDefinitions/@letter"/>
        <xsl:variable name="pageId" select="/wordDefinitions/@page"/>
        
           <ul class="letters">
               <xsl:call-template name="letters-items"/>
           </ul>
    </xsl:template>

    <xsl:template name="letters-items">
        <xsl:variable name="letter" select="/wordDefinitions/@letter"/>
        <xsl:variable name="wordDefinitions" select="/wordDefinitions"/>

        <xsl:call-template name="letters-item">
            <xsl:with-param name="selected-letter" select="$letter"/>
            <xsl:with-param name="letter" select="$nonletter"/>
            <xsl:with-param name="wordDefinitions" select="$wordDefinitions"/>
        </xsl:call-template>
        
        <xsl:for-each select="exsl:node-set($letters)/letters/l">
            <xsl:call-template name="letters-item">
                <xsl:with-param name="selected-letter" select="$letter"/>
                <xsl:with-param name="letter" select="."/>
	            <xsl:with-param name="wordDefinitions" select="$wordDefinitions"/>
            </xsl:call-template>
        </xsl:for-each>
    </xsl:template>
    
    <xsl:template name="letters-item">
        <xsl:param name="selected-letter"/>
        <xsl:param name="letter"/>
        <xsl:param name="wordDefinitions"/>
        
        <li>
        	<!-- xsl:if test="$selected-letter = $letter"><xsl:attribute name="class">current</xsl:attribute></xsl:if> -->
        	<xsl:choose>
        		<xsl:when test="$wordDefinitions/wordDefinition[@firstLetter = $letter] or ($letter = $nonletter and $wordDefinitions/wordDefinition[not(@firstLetter = exsl:node-set($letters)/letters/l)])">
        			<a href="#{$letter}" class="letter">
                		<xsl:value-of select="$letter"/>
            		</a>
        		</xsl:when>
        		<xsl:otherwise><span class="letter"><xsl:value-of select="$letter"/></span></xsl:otherwise>
        	</xsl:choose>
        </li>
    </xsl:template>
    
    <xsl:template name="utils.nl2br">
        <xsl:param name="input"/>
        <xsl:param name="s1"><xsl:text>
</xsl:text></xsl:param>
        <xsl:choose>
            <xsl:when test="contains($input, $s1)">
                <xsl:variable name="rest">
                    <xsl:call-template name="utils.nl2br">
                        <xsl:with-param name="input" select="substring-after($input, $s1)"/>
                        <xsl:with-param name="s1" select="$s1"/>
                    </xsl:call-template>
                </xsl:variable>
                <xsl:value-of select="substring-before($input, $s1)"/>
                <br/>
                <xsl:copy-of select="$rest"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$input"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
</xsl:stylesheet>
