<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2011 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:exsl="http://exslt.org/common"
                xmlns:math="java.lang.Math"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                extension-element-prefixes="exsl math resolver ametys">
    
    <xsl:import href="service:glossary://pages/services/glossary/glossary_1.0.xsl"/>
    
    <xsl:variable name="generateEmptyLetters" select="true()"/>
    
    <xsl:template name="common-service-head-js">
        <script src="{ametys:pluginResourceURL('glossary', 'js/glossary.js')}" type="text/javascript"/>

        <script type="text/javascript">
               $j(function(){
                   var hash = window.location.hash == '' ? '' : window.location.hash.substring(1);
                   var letter = hash == '' ? 'A' : hash.substring(0, 1).toUpperCase();
                   insertLetterLinks('<xsl:value-of select="$uniqueId"/>');
                   hideLetters('<xsl:value-of select="$uniqueId"/>');
                   showPage('<xsl:value-of select="$uniqueId"/>', letter);
               });
        </script>
    </xsl:template>
    
</xsl:stylesheet>
