/*
 *  Copyright 2011 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

var insertLetterLinks = function(uniqueId)
{
    $j('#definitions-' + uniqueId + ' .letters a').each(function(index){
        var letter = $j(this).text() == '#' ? '0' : $j(this).text();
        $j(this).click(function(event) {
            showPage(uniqueId, letter);
            return false;
        });
    });
}

var hideLetters = function(uniqueId)
{
    $j('#definitions-' + uniqueId + ' .letter-definitions .title-letter').each(function(index){
        $j(this).hide();
    });
}

var showPage = function(uniqueId, letter)
{
    $j('#definitions-' + uniqueId + ' .letter-definitions').each(function(index) {
        if ($j(this).attr('id') == 'definitions-' + uniqueId + '-letter-' + letter)
        {
            $j(this).show();
        }
        else
        {
            $j(this).hide();
        }
    });
    var containsText = letter == '0' ? '#' : letter;
    $j('#definitions-' + uniqueId + ' .letters li.current').removeClass('current');
    $j('#definitions-' + uniqueId + ' .letters li a:contains(' + containsText + ')').parent().addClass('current');
}
