/*
 *  Copyright 2011 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.glossary;

import javax.jcr.Node;
import javax.jcr.RepositoryException;

import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.jcr.SimpleAmetysObjectFactory;

/**
 * Factory which creates {@link Definition} objects, which represent a word definition entry in the glossary.
 */
public class DefaultDefinitionFactory extends SimpleAmetysObjectFactory
{
    
    /** The definition container node type. */
    public static final String DEFINITION_ROOT_NODE_TYPE = "ametys:wordDefinitions";
    
    /** The definition node type. */
    public static final String DEFINITION_NODE_TYPE = "ametys:wordDefinition";
    
    @Override
    public DefaultDefinition getAmetysObject(Node node, String parentPath) throws AmetysRepositoryException, RepositoryException
    {
        return new DefaultDefinition(node, parentPath, this);
    }
    
}
