/*
 *  Copyright 2011 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.glossary;

import java.util.Collection;
import java.util.Set;

import org.ametys.plugins.repository.AmetysRepositoryException;

/**
 * A glossary definition.
 */
public interface Definition
{
    
    /**
     * Get the word.
     * @return the word
     * @throws AmetysRepositoryException if an error occurs.
     */
    public String getWord() throws AmetysRepositoryException;
    
    /**
     * Set the word.
     * @param word the word to set
     * @throws AmetysRepositoryException if an error occurs.
     */
    public void setWord(String word) throws AmetysRepositoryException;
    
    /**
     * Get the variants.
     * @return the variants
     * @throws AmetysRepositoryException if an error occurs.
     */
    public Set<String> getVariants() throws AmetysRepositoryException;
    
    /**
     * Set the variants.
     * @param variants the variants to set
     * @throws AmetysRepositoryException if an error occurs.
     */
    public void setVariants(Collection<String> variants) throws AmetysRepositoryException;
    
    /**
     * Get the content.
     * @return _the content
     * @throws AmetysRepositoryException if an error occurs.
     */
    public String getContent() throws AmetysRepositoryException;
    
    /**
     * Set the content.
     * @param content the content to set
     * @throws AmetysRepositoryException if an error occurs.
     */
    public void setContent(String content) throws AmetysRepositoryException;
    
    /**
     * Get the displayOnText.
     * @return _the displayOnText
     * @throws AmetysRepositoryException if an error occurs.
     */
    public boolean displayOnText() throws AmetysRepositoryException;
    
    /**
     * Set the displayOnText.
     * @param displayOnText the displayOnText to set
     * @throws AmetysRepositoryException if an error occurs.
     */
    public void setDisplayOnText(boolean displayOnText) throws AmetysRepositoryException;
    
    /**
     * Get the themes.
     * 
     * @return the themes in an Array
     * @throws AmetysRepositoryException if an error occurs.
     */
    public String[] getThemes() throws AmetysRepositoryException;

    /**
     * Set the themes.
     * 
     * @param themes the themes to set.
     * @throws AmetysRepositoryException if an error occurs.
     */
    public void setThemes(String[] themes) throws AmetysRepositoryException;

    /**
     * Remove theme if exist
     * 
     * @param themeId The id of theme to remove
     * @throws AmetysRepositoryException if an error occurs
     */
    public void removeTheme(String themeId) throws AmetysRepositoryException;
    
    /**
     * Get all forms.
     * @return a list of all the word forms (word + variants).
     * @throws AmetysRepositoryException if an error occurs.
     */
    public Set<String> getAllForms() throws AmetysRepositoryException;
    
}
