/*
 *  Copyright 2012 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.glossary;

/**
 * Events relative to glossary (mainly word definitions).
 */
public interface GlossaryEvents
{
    
    /** Fired when a definition is created. */
    public static final String DEFINITION_CREATED = "definition.created";
    
    /** Fired when a definition is modified. */
    public static final String DEFINITION_MODIFIED = "definition.modified";
    
    /** Fired when a definition is deleted. */
    public static final String DEFINITION_DELETED = "definition.deleted";
    
}
