/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.glossary.statistics;

import java.util.List;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

import org.ametys.plugins.glossary.DefaultDefinitionFactory;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.runtime.plugin.component.PluginAware;
import org.ametys.runtime.plugins.admin.statistics.Statistics;
import org.ametys.runtime.plugins.admin.statistics.StatisticsNode;
import org.ametys.runtime.plugins.admin.statistics.StatisticsProvider;
import org.ametys.runtime.plugins.admin.statistics.StatisticsValue;

/**
 * Statistics for glossary
 */
public class GlossaryStatisticsProvider extends AbstractLogEnabled implements StatisticsProvider, Serviceable, PluginAware
{
    private String _id;
    private AmetysObjectResolver _ametysObjectResolver;

    public void service(ServiceManager manager) throws ServiceException
    {
        _ametysObjectResolver = (AmetysObjectResolver) manager.lookup(AmetysObjectResolver.ROLE);
    }
    
    public void setPluginInfo(String pluginName, String featureName, String id)
    {
        _id = id;
    }

    private long _countWords()
    {
        try (AmetysObjectIterable<AmetysObject> nodes = _ametysObjectResolver.query("//element(*, " + DefaultDefinitionFactory.DEFINITION_NODE_TYPE + ")"))
        {
            return nodes.getSize();
        }
    }
    
    public Statistics getStatistics()
    {
        return new StatisticsNode(
            _id,
            new I18nizableText("plugin.glossary", "PLUGINS_GLOSSARY_STATISTICS_LABEL"),
            "ametysicon-alphabet-a",
            null,
            List.of(
                new StatisticsValue(
                    "count",
                    new I18nizableText("plugin.glossary", "PLUGINS_GLOSSARY_STATISTICS_COUNT_LABEL"),
                    "ametysicon-maths-number-zero-one",
                    _countWords()
                )
            ),
            true
        );
    }
}
