/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.glossary.theme;

import javax.jcr.Node;
import javax.jcr.RepositoryException;

import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.jcr.SimpleAmetysObjectFactory;

/**
 * Factory which creates {@link Theme} objects, which represent a directory for glossary themes.
 */
public class DefaultThemeFactory extends SimpleAmetysObjectFactory
{
    
    /** The theme container node type. */
    public static final String THEME_ROOT_NODE_TYPE = "ametys:glossaryDirectoryThemes";
    
    /** The theme node type. */
    public static final String THEME_NODE_TYPE = "ametys:glossaryDirectoryTheme";
    
    @Override
    public DefaultTheme getAmetysObject(Node node, String parentPath) throws AmetysRepositoryException, RepositoryException
    {
        return new DefaultTheme(node, parentPath, this);
    }
    
}
