/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.glossary.theme;

import org.ametys.plugins.glossary.DefaultDefinition;
import org.ametys.plugins.repository.query.expression.Expression;

/**
 * Build a {@link Expression} for glossary themes
 *
 */
public class ThemeExpression implements Expression
{
    /** The theme label. */
    protected String _value;
    
    /**
     * Build a ThemeExpression from a label.
     * @param value the theme label.
     */
    public ThemeExpression(String value)
    {
        _value = value;
    }
    
    @Override
    public String build()
    {
        StringBuilder buff = new StringBuilder();
        
        buff.append('@').append(DefaultDefinition.ATTRIBUTE_THEMES).append(Operator.EQ).append("'").append(_value).append("'");
        
        return buff.toString();
    }
}

