/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.glpi.dynamic;

import java.util.Collections;
import java.util.List;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.glpi.GlpiTicket;
import org.ametys.plugins.glpi.TicketGlpiManager;
import org.ametys.plugins.linkdirectory.dynamic.AbstractInternalDynamicInformationGenerator;
import org.ametys.plugins.linkdirectory.dynamic.DynamicInformationException;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class TicketsDynamicInformationGenerator
extends AbstractInternalDynamicInformationGenerator {
    private TicketGlpiManager _ticketGlpiManager;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._ticketGlpiManager = (TicketGlpiManager)((Object)serviceManager.lookup(TicketGlpiManager.ROLE));
    }

    protected void saxShortValue() throws SAXException, DynamicInformationException {
        try {
            UserIdentity currentUser = this.getCurrentUser();
            if (currentUser == null) {
                throw new DynamicInformationException("Unable to retrieve open GLPI tickets, user is not connected", DynamicInformationException.ExceptionType.UNAUTHORIZED);
            }
            int count = this._ticketGlpiManager.getCountOpenTickets(currentUser);
            if (count == -1) {
                throw new DynamicInformationException("Unable to retrieve open GLPI tickets", DynamicInformationException.ExceptionType.UNKNOWN);
            }
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"short-value", (String)String.valueOf(count));
        }
        catch (DynamicInformationException | SAXException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DynamicInformationException("Unable to sax short value for GLPI tickets", (Throwable)e);
        }
    }

    protected void saxLongValue() throws SAXException, DynamicInformationException {
        try {
            UserIdentity currentUser = this.getCurrentUser();
            if (currentUser == null) {
                throw new DynamicInformationException("Unable to retrieve open GLPI tickets, user is not connected", DynamicInformationException.ExceptionType.UNAUTHORIZED);
            }
            int openCount = this._ticketGlpiManager.getCountOpenTickets(currentUser);
            if (openCount == -1) {
                throw new DynamicInformationException("Unable to retrieve open GLPI tickets", DynamicInformationException.ExceptionType.UNKNOWN);
            }
            I18nizableText longValue = new I18nizableText("plugin.glpi", "PLUGINS_GLPI_DYNAMIC_INFORMATION_NB_TICKETS", Collections.singletonList(String.valueOf(openCount)));
            longValue.toSAX(this.contentHandler, "long-value");
        }
        catch (DynamicInformationException | SAXException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DynamicInformationException("Unable to retrieve the number of open GLPI tickets", (Throwable)e);
        }
    }

    protected void saxTooltips() throws SAXException, DynamicInformationException {
        try {
            UserIdentity currentUser = this.getCurrentUser();
            if (currentUser == null) {
                throw new DynamicInformationException("Unable to retrieve open GLPI tickets, user is not connected", DynamicInformationException.ExceptionType.UNAUTHORIZED);
            }
            List<GlpiTicket> openTickets = this._ticketGlpiManager.getOpenTickets(currentUser);
            int maxItems = this.getMaxItems();
            for (int i = 0; (maxItems == -1 || i < maxItems) && i < openTickets.size(); ++i) {
                GlpiTicket glpiTicket = openTickets.get(i);
                int id = glpiTicket.getId();
                String title = glpiTicket.getTitle();
                int status = glpiTicket.getStatusId();
                I18nizableText statusLabel = this._ticketGlpiManager.getGlpiStatusLabel(status);
                XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"item");
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"title", (String)String.valueOf(id));
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"summary", (String)(title != null ? title : ""));
                statusLabel.toSAX(this.contentHandler, "footer");
                XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"item");
            }
        }
        catch (DynamicInformationException | SAXException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DynamicInformationException("Unable to retrieve open GLPI tickets information", (Throwable)e);
        }
    }
}

